/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.down;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.cell.DuplicateType;
import com.bstek.ureport.build.cell.down.DownDuplicate;
import com.bstek.ureport.definition.BlankCellInfo;
import com.bstek.ureport.definition.value.SimpleValue;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Row;

public class CellDownDuplicator {
    private Cell cell;
    private int cellRowNumber;
    private DuplicateType duplicateType;
    private BlankCellInfo blankCellInfo;
    private boolean nonChild = false;

    public CellDownDuplicator(Cell cell, DuplicateType duplicateType, int cellRowNumber) {
        this.cell = cell;
        this.cellRowNumber = cellRowNumber;
        this.duplicateType = duplicateType;
    }

    public CellDownDuplicator(Cell cell, DuplicateType duplicateType, BlankCellInfo blankCellInfo, int cellRowNumber) {
        this.cell = cell;
        this.cellRowNumber = cellRowNumber == 0 ? cell.getRow().getRowNumber() : cellRowNumber;
        this.duplicateType = duplicateType;
        this.blankCellInfo = blankCellInfo;
    }

    public Cell duplicate(DownDuplicate downDuplicate, Cell newMainCell) {
        switch (this.duplicateType) {
            case Blank: {
                this.processBlankCell(downDuplicate, newMainCell);
                break;
            }
            case Self: {
                this.processSelfBlankCell(downDuplicate);
                break;
            }
            case IncreseSpan: {
                this.processIncreaseSpanCell(downDuplicate);
                break;
            }
            case Duplicate: {
                throw new ReportComputeException("Invalid duplicator.");
            }
        }
        return null;
    }

    public Cell duplicateChildrenCell(DownDuplicate downDuplicate, Cell leftParent, Cell originalCell, boolean parentNonChild) {
        Cell topParentCell;
        Cell leftParentCell;
        Cell newCell = this.cell.newCell();
        Row newRow = downDuplicate.newRow(newCell.getRow(), this.cellRowNumber);
        newRow.getCells().add(newCell);
        newCell.getColumn().getCells().add(newCell);
        newCell.setRow(newRow);
        if (newCell.getLeftParentCell() == originalCell) {
            newCell.setLeftParentCell(leftParent);
            if (parentNonChild) {
                this.nonChild = true;
            }
        } else {
            this.nonChild = true;
        }
        if ((leftParentCell = newCell.getLeftParentCell()) != null) {
            leftParentCell.addRowChild(newCell);
        }
        if ((topParentCell = newCell.getTopParentCell()) != null) {
            topParentCell.addColumnChild(newCell);
        }
        Context context = downDuplicate.getContext();
        Value value = newCell.getValue();
        if (value instanceof SimpleValue) {
            newCell.setData(value.getValue());
            newCell.setProcessed(true);
            context.addReportCell(newCell);
        } else if (this.nonChild) {
            newCell.setValue(new SimpleValue(""));
            context.addBlankCell(newCell);
        } else {
            context.addCell(newCell);
        }
        return newCell;
    }

    private void processBlankCell(DownDuplicate downDuplicate, Cell newMainCell) {
        Context context = downDuplicate.getContext();
        Cell newBlankCell = this.cell.newRowBlankCell(context, this.blankCellInfo, downDuplicate.getMainCell());
        if (this.blankCellInfo.isParent() && newMainCell.getLeftParentCell() == this.cell) {
            newMainCell.setLeftParentCell(newBlankCell);
        }
        Row newRow = downDuplicate.newRow(newBlankCell.getRow(), this.cellRowNumber);
        newRow.getCells().add(newBlankCell);
        newBlankCell.getColumn().getCells().add(newBlankCell);
        newBlankCell.setRow(newRow);
        context.addReportCell(newBlankCell);
    }

    private void processSelfBlankCell(DownDuplicate downDuplicate) {
        Cell topParentCell;
        Cell newBlankCell = this.cell.newCell();
        newBlankCell.setValue(new SimpleValue(""));
        Row newRow = downDuplicate.newRow(newBlankCell.getRow(), this.cellRowNumber);
        newRow.getCells().add(newBlankCell);
        newBlankCell.getColumn().getCells().add(newBlankCell);
        newBlankCell.setRow(newRow);
        Cell leftParentCell = newBlankCell.getLeftParentCell();
        if (leftParentCell != null) {
            leftParentCell.addRowChild(newBlankCell);
        }
        if ((topParentCell = newBlankCell.getTopParentCell()) != null) {
            topParentCell.addColumnChild(newBlankCell);
        }
        Context context = downDuplicate.getContext();
        context.addBlankCell(newBlankCell);
    }

    private void processIncreaseSpanCell(DownDuplicate downDuplicate) {
        int rowSpan = this.cell.getRowSpan();
        if ((rowSpan += downDuplicate.getRowSize()) == 1) {
            ++rowSpan;
        }
        this.cell.setRowSpan(rowSpan);
    }

    public DuplicateType getDuplicateType() {
        return this.duplicateType;
    }

    public Cell getCell() {
        return this.cell;
    }

    public boolean isNonChild() {
        return this.nonChild;
    }

    public void setNonChild(boolean nonChild) {
        this.nonChild = nonChild;
    }
}

