/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.right;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.cell.right.CellRightDuplicator;
import com.bstek.ureport.build.cell.right.RightDuplicate;
import com.bstek.ureport.build.cell.right.RightDuplocatorWrapper;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CellRightDuplicateUnit {
    private Cell mainCell;
    private int mainCellColNumber;
    private Context context;
    private RightDuplicate rightDuplicate;
    private RightDuplocatorWrapper rightDuplocatorWrapper;

    public CellRightDuplicateUnit(Context context, RightDuplocatorWrapper rightDuplocatorWrapper, Cell mainCell, int mainCellColNumber, int colSize) {
        this.context = context;
        this.rightDuplocatorWrapper = rightDuplocatorWrapper;
        this.mainCell = mainCell;
        this.mainCellColNumber = mainCellColNumber;
        this.rightDuplicate = new RightDuplicate(mainCell, colSize, context);
    }

    public void duplicate(Cell cell, int index) {
        HashMap<Cell, Cell> newCellMap = new HashMap<Cell, Cell>();
        newCellMap.put(this.mainCell, cell);
        this.rightDuplicate.setIndex(index);
        for (CellRightDuplicator childDuplicator : this.rightDuplocatorWrapper.getMainCellChildren()) {
            Cell newCell = childDuplicator.duplicateChildrenCell(this.rightDuplicate, cell, this.mainCell, false);
            newCellMap.put(childDuplicator.getCell(), newCell);
            this.processChildrenCells(newCell, childDuplicator.getCell(), newCellMap, this.rightDuplicate, childDuplicator.isNonChild());
            childDuplicator.setNonChild(false);
        }
        for (CellRightDuplicator cellRightDuplicator : this.rightDuplocatorWrapper.getCellDuplicators()) {
            cellRightDuplicator.duplicate(this.rightDuplicate, cell);
        }
        Column newCol = this.rightDuplicate.newColumn(cell.getColumn(), this.mainCellColNumber);
        cell.setColumn(newCol);
        newCol.getCells().add(cell);
        cell.getRow().getCells().add(cell);
        this.context.addReportCell(cell);
        this.rightDuplicate.reset();
        for (Cell newCell : newCellMap.values()) {
            Cell originLeftCell = newCell.getLeftParentCell();
            if (originLeftCell == null || !newCellMap.containsKey(originLeftCell)) continue;
            newCell.setLeftParentCell((Cell)newCellMap.get(originLeftCell));
        }
    }

    public void complete() {
        this.rightDuplicate.complete();
    }

    private void processChildrenCells(Cell cell, Cell originalCell, Map<Cell, Cell> newCellMap, RightDuplicate rightDuplicate, boolean parentNonChild) {
        List<CellRightDuplicator> childCellRightDuplicators = this.rightDuplocatorWrapper.fetchChildrenDuplicator(originalCell);
        if (childCellRightDuplicators == null) {
            return;
        }
        for (CellRightDuplicator duplicator : childCellRightDuplicators) {
            Cell newCell = duplicator.duplicateChildrenCell(rightDuplicate, cell, originalCell, parentNonChild);
            newCellMap.put(duplicator.getCell(), newCell);
            this.processChildrenCells(newCell, duplicator.getCell(), newCellMap, rightDuplicate, duplicator.isNonChild());
            duplicator.setNonChild(false);
        }
    }
}

