/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.cache;

import com.bstek.ureport.cache.DefaultMemoryReportDefinitionCache;
import com.bstek.ureport.cache.ReportCache;
import com.bstek.ureport.cache.ReportDefinitionCache;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.definition.ReportDefinition;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CacheUtils
implements ApplicationContextAware {
    private static ReportCache reportCache;
    private static ReportDefinitionCache reportDefinitionCache;
    private static String CHART_DATA_key;

    public static ChartData getChartData(String chartId) {
        Map chartDataMap;
        String key = CHART_DATA_key;
        if (reportCache != null && (chartDataMap = (Map)reportCache.getObject(key)) != null) {
            return (ChartData)chartDataMap.get(chartId);
        }
        return null;
    }

    public static void storeChartDataMap(Map<String, ChartData> map) {
        String key = CHART_DATA_key;
        if (reportCache != null) {
            reportCache.storeObject(key, map);
        }
    }

    public static Object getObject(String file) {
        if (reportCache != null) {
            return reportCache.getObject(file);
        }
        return null;
    }

    public static void storeObject(String file, Object obj) {
        if (reportCache != null) {
            reportCache.storeObject(file, obj);
        }
    }

    public static ReportDefinition getReportDefinition(String file) {
        return reportDefinitionCache.getReportDefinition(file);
    }

    public static void cacheReportDefinition(String file, ReportDefinition reportDefinition) {
        reportDefinitionCache.cacheReportDefinition(file, reportDefinition);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection reportCaches;
        Collection coll = applicationContext.getBeansOfType(ReportCache.class).values();
        for (ReportCache cache : coll) {
            if (cache.disabled()) continue;
            reportCache = cache;
            break;
        }
        reportDefinitionCache = (reportCaches = applicationContext.getBeansOfType(ReportDefinitionCache.class).values()).size() == 0 ? new DefaultMemoryReportDefinitionCache() : (ReportDefinitionCache)reportCaches.iterator().next();
    }

    static {
        CHART_DATA_key = "_chart_data_";
    }
}

