/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.chart.dataset.impl;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.chart.dataset.Dataset;
import com.bstek.ureport.chart.dataset.impl.category.BarDataset;
import com.bstek.ureport.chart.dataset.impl.category.LineDataset;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class MixDataset
implements Dataset {
    private List<BarDataset> barDatasets = new ArrayList<BarDataset>();
    private List<LineDataset> lineDatasets = new ArrayList<LineDataset>();

    @Override
    public String buildDataJson(Context context, Cell cell) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"datasets\":[");
        int index = 0;
        for (BarDataset barDataset : this.barDatasets) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append(barDataset.toMixJson(context, cell, index));
        }
        for (LineDataset lineDataset : this.lineDatasets) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append(lineDataset.toMixJson(context, cell, index));
        }
        sb.append("],");
        String labels = null;
        if (this.barDatasets.size() > 0) {
            labels = this.barDatasets.get(0).getLabels();
        } else if (this.lineDatasets.size() > 0) {
            labels = this.lineDatasets.get(0).getLabels();
        } else {
            throw new ReportComputeException("Mix chart need one dataset at least.");
        }
        sb.append("labels:" + labels);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String getType() {
        return "bar";
    }

    public List<BarDataset> getBarDatasets() {
        return this.barDatasets;
    }

    public void setBarDatasets(List<BarDataset> barDatasets) {
        this.barDatasets = barDatasets;
    }

    public List<LineDataset> getLineDatasets() {
        return this.lineDatasets;
    }

    public void setLineDatasets(List<LineDataset> lineDatasets) {
        this.lineDatasets = lineDatasets;
    }
}

