/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.searchform;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.searchform.InputComponent;
import com.bstek.ureport.definition.searchform.Option;
import com.bstek.ureport.definition.searchform.RenderContext;
import com.bstek.ureport.exception.DatasetUndefinitionException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SelectInputComponent
extends InputComponent {
    private boolean useDataset;
    private String dataset;
    private String labelField;
    private String valueField;
    private List<Option> options;

    @Override
    String inputHtml(RenderContext context) {
        String name = this.getBindParameter();
        String pvalue = context.getParameter(name) == null ? "" : context.getParameter(name);
        StringBuilder sb = new StringBuilder();
        sb.append("<select style=\"padding:3px;height:28px\" id='" + context.buildComponentId(this) + "' name='" + name + "' class='form-control'>");
        if (this.useDataset && StringUtils.isNotBlank((CharSequence)this.dataset)) {
            Dataset ds = context.getDataset(this.dataset);
            if (ds == null) {
                throw new DatasetUndefinitionException(this.dataset);
            }
            for (Object obj : ds.getData()) {
                Object label = Utils.getProperty(obj, this.labelField);
                Object value = Utils.getProperty(obj, this.valueField);
                String selected = value.equals(pvalue) ? "selected" : "";
                sb.append("<option value='" + value + "' " + selected + ">" + label + "</option>");
            }
            if (pvalue.equals("")) {
                sb.append("<option value='' selected></option>");
            }
        } else {
            for (Option option : this.options) {
                String value = option.getValue();
                String selected = value.equals(pvalue) ? "selected" : "";
                sb.append("<option value='" + value + "' " + selected + ">" + option.getLabel() + "</option>");
            }
            if (pvalue.equals("")) {
                sb.append("<option value='' selected></option>");
            }
        }
        sb.append("</select>");
        return sb.toString();
    }

    @Override
    public String initJs(RenderContext context) {
        String name = this.getBindParameter();
        StringBuilder sb = new StringBuilder();
        sb.append("formElements.push(");
        sb.append("function(){");
        sb.append("if(''==='" + name + "'){");
        sb.append("alert('\u5217\u8868\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!');");
        sb.append("throw '\u5217\u8868\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!'");
        sb.append("}");
        sb.append("return {");
        sb.append("\"" + name + "\":");
        sb.append("$('#" + context.buildComponentId(this) + "').val()");
        sb.append("}");
        sb.append("}");
        sb.append(");");
        return sb.toString();
    }

    public boolean isUseDataset() {
        return this.useDataset;
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public void setLabelField(String labelField) {
        this.labelField = labelField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public void setUseDataset(boolean useDataset) {
        this.useDataset = useDataset;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public List<Option> getOptions() {
        return this.options;
    }
}

