/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.builder.right;

import com.bstek.ureport.Range;
import com.bstek.ureport.definition.BlankCellInfo;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.parser.BuildUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TopParentCellCreator {
    public List<Range> buildParentCells(CellDefinition cell) {
        ArrayList<Range> rangeList = new ArrayList<Range>();
        Range childRange = this.buildChildrenCellRange(cell);
        ArrayList<CellDefinition> parentCells = new ArrayList<CellDefinition>();
        this.collectParentCells(cell, parentCells);
        this.buildParents(cell, parentCells, childRange, rangeList);
        return rangeList;
    }

    private void collectParentCells(CellDefinition cell, List<CellDefinition> parentCells) {
        CellDefinition topParentCell = cell.getTopParentCell();
        if (topParentCell == null) {
            return;
        }
        parentCells.add(topParentCell);
        this.collectParentCells(topParentCell, parentCells);
    }

    private void buildParents(CellDefinition mainCell, List<CellDefinition> parentCells, Range childRange, List<Range> rangeList) {
        int colNumberStart = mainCell.getColumnNumber();
        int colNumberEnd = BuildUtils.buildColNumberEnd(mainCell, colNumberStart);
        rangeList.add(new Range(colNumberStart, colNumberEnd));
        int start = childRange.getStart();
        int end = childRange.getEnd();
        Map<String, BlankCellInfo> newBlankCellsMap = mainCell.getNewBlankCellsMap();
        boolean increase = true;
        for (CellDefinition parentCell : parentCells) {
            String parentCellName = parentCell.getName();
            int parentColNumberStart = parentCell.getColumnNumber();
            int parentColNumberEnd = BuildUtils.buildColNumberEnd(parentCell, parentColNumberStart);
            int offset = parentColNumberStart - colNumberStart;
            int parentColSpan = parentCell.getColSpan();
            boolean isOut = this.assertOut(parentCell, mainCell, childRange);
            if (isOut) {
                increase = false;
                boolean doBlank = this.assertDoBlank(parentCell.getTopParentCell(), parentCell, mainCell, childRange);
                if (!doBlank) continue;
                newBlankCellsMap.put(parentCellName, new BlankCellInfo(offset, parentColSpan, true));
                rangeList.add(new Range(parentColNumberStart, parentColNumberEnd));
                continue;
            }
            if (start != -1 && start < parentColNumberStart || end > parentColNumberEnd) {
                newBlankCellsMap.put(parentCellName, new BlankCellInfo(offset, parentColSpan, true));
                rangeList.add(new Range(parentColNumberStart, parentColNumberEnd));
                increase = false;
                continue;
            }
            if (increase) {
                mainCell.getIncreaseSpanCellNames().add(parentCellName);
                continue;
            }
            newBlankCellsMap.put(parentCellName, new BlankCellInfo(offset, parentColSpan, true));
            rangeList.add(new Range(parentColNumberStart, parentColNumberEnd));
        }
    }

    private boolean assertDoBlank(CellDefinition nextParentCell, CellDefinition parentCell, CellDefinition mainCell, Range childRange) {
        if (nextParentCell == null) {
            return false;
        }
        boolean isOut = this.assertOut(nextParentCell, mainCell, childRange);
        if (isOut) {
            return this.assertDoBlank(nextParentCell.getTopParentCell(), parentCell, mainCell, childRange);
        }
        int start = parentCell.getColumnNumber();
        int end = BuildUtils.buildColNumberEnd(parentCell, start);
        int nextStart = nextParentCell.getColumnNumber();
        if (nextStart <= end) {
            return true;
        }
        return this.assertDoBlank(nextParentCell.getTopParentCell(), parentCell, mainCell, childRange);
    }

    private boolean assertOut(CellDefinition parentCell, CellDefinition mainCell, Range childRange) {
        int start = parentCell.getColumnNumber();
        int end = BuildUtils.buildColNumberEnd(parentCell, start);
        int rangeStart = childRange.getStart();
        int rangeEnd = childRange.getEnd();
        if (rangeStart != -1 && (start >= rangeStart && start <= rangeEnd || end >= rangeStart && end <= rangeEnd)) {
            return false;
        }
        int colStart = mainCell.getColumnNumber();
        int colEnd = BuildUtils.buildColNumberEnd(mainCell, colStart);
        return !(start >= colStart && start <= colEnd || end >= colStart && end <= colEnd) && (start > colStart || end < colEnd);
    }

    private Range buildChildrenCellRange(CellDefinition mainCell) {
        Range range = new Range();
        List<CellDefinition> childrenCells = mainCell.getColumnChildrenCells();
        for (CellDefinition childCell : childrenCells) {
            int childColumnNumberStart = childCell.getColumnNumber();
            int childColSpan = childCell.getColSpan();
            childColSpan = childColSpan > 0 ? childColSpan - 1 : childColSpan;
            int childColumnNumberEnd = childColumnNumberStart + childColSpan;
            if (range.getStart() == -1 || childColumnNumberStart < range.getStart()) {
                range.setStart(childColumnNumberStart);
            }
            if (childColumnNumberEnd <= range.getEnd()) continue;
            range.setEnd(childColumnNumberEnd);
        }
        return range;
    }
}

