/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.excel.high.builder;

import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.PaperType;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Image;
import com.bstek.ureport.model.Row;
import com.bstek.ureport.utils.UnitUtils;
import java.util.List;
import org.apache.poi.ss.usermodel.PaperSize;
import org.apache.poi.ss.usermodel.PrintOrientation;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;

public abstract class ExcelBuilder {
    protected int getWholeWidth(List<Column> columns, int colNumber, int colSpan) {
        Column col = columns.get(colNumber);
        int start = colNumber + 1;
        int end = colNumber + colSpan;
        int w = col.getWidth();
        for (int i = start; i < end; ++i) {
            Column c = columns.get(i);
            w += c.getWidth();
        }
        w = UnitUtils.pointToPixel(w);
        return w;
    }

    protected int getWholeHeight(List<Row> rows, int rowNumber, int rowSpan) {
        Row row = rows.get(rowNumber);
        int start = rowNumber + 1;
        int end = rowNumber + rowSpan;
        int h = row.getRealHeight();
        for (int i = start; i < end; ++i) {
            Row r = rows.get(i);
            h += r.getRealHeight();
        }
        h = UnitUtils.pointToPixel(h);
        return h;
    }

    protected Sheet createSheet(SXSSFWorkbook wb, Paper paper, String name) {
        SXSSFSheet sheet = null;
        sheet = name == null ? wb.createSheet() : wb.createSheet(name);
        PaperType paperType = paper.getPaperType();
        XSSFPrintSetup printSetup = (XSSFPrintSetup)sheet.getPrintSetup();
        Orientation orientation = paper.getOrientation();
        if (orientation.equals(Orientation.landscape)) {
            printSetup.setOrientation(PrintOrientation.LANDSCAPE);
        }
        this.setupPaper(paperType, printSetup);
        int leftMargin = paper.getLeftMargin();
        int rightMargin = paper.getRightMargin();
        int topMargin = paper.getTopMargin();
        int bottomMargin = paper.getBottomMargin();
        sheet.setMargin((short)0, (double)UnitUtils.pointToInche(leftMargin));
        sheet.setMargin((short)1, (double)UnitUtils.pointToInche(rightMargin));
        sheet.setMargin((short)2, (double)UnitUtils.pointToInche(topMargin));
        sheet.setMargin((short)3, (double)UnitUtils.pointToInche(bottomMargin));
        return sheet;
    }

    protected int buildImageFormat(Image img) {
        int type = 6;
        String path = img.getPath();
        if (path == null) {
            return type;
        }
        if ((path = path.toLowerCase()).endsWith("jpg") || path.endsWith("jpeg")) {
            type = 5;
        }
        return type;
    }

    protected boolean setupPaper(PaperType paperType, XSSFPrintSetup printSetup) {
        boolean setup = false;
        switch (paperType) {
            case A0: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case A1: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case A2: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case A3: {
                printSetup.setPaperSize(PaperSize.A3_PAPER);
                setup = true;
                break;
            }
            case A4: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                setup = true;
                break;
            }
            case A5: {
                printSetup.setPaperSize(PaperSize.A5_PAPER);
                setup = true;
                break;
            }
            case A6: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case A7: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case A8: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case A9: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case A10: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B0: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B1: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B2: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B3: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B4: {
                printSetup.setPaperSize(PaperSize.B4_PAPER);
                setup = true;
                break;
            }
            case B5: {
                printSetup.setPaperSize(PaperSize.B4_PAPER);
                setup = true;
                break;
            }
            case B6: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B7: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B8: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B9: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case B10: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
                break;
            }
            case CUSTOM: {
                printSetup.setPaperSize(PaperSize.A4_PAPER);
            }
        }
        return setup;
    }
}

