/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

public class FormatNumberFunction
implements Function {
    private final String defaultPattern = "#";

    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList == null) {
            return "";
        }
        Object obj = null;
        String pattern = "#";
        if (dataList.size() == 1) {
            obj = this.buildExpressionData(dataList.get(0));
        } else if (dataList.size() > 1) {
            obj = this.buildExpressionData(dataList.get(0));
            Object patternData = this.buildExpressionData(dataList.get(1));
            if (patternData != null) {
                pattern = patternData.toString();
            }
        }
        if (obj == null) {
            throw new ReportComputeException("Function [formatnumber] need a number parameter at least");
        }
        BigDecimal bigData = Utils.toBigDecimal(obj);
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(bigData.doubleValue());
    }

    private Object buildExpressionData(ExpressionData<?> data) {
        if (data instanceof ObjectListExpressionData) {
            ObjectListExpressionData listExpressionData = (ObjectListExpressionData)data;
            Object list = listExpressionData.getData();
            if (list.size() > 0) {
                return list.get(0);
            }
        } else {
            BindDataListExpressionData bindDataList;
            Object list;
            if (data instanceof ObjectExpressionData) {
                return ((ObjectExpressionData)data).getData();
            }
            if (data instanceof BindDataListExpressionData && (list = (bindDataList = (BindDataListExpressionData)data).getData()).size() > 0) {
                return ((BindData)list.get(0)).getValue();
            }
        }
        return null;
    }

    @Override
    public String name() {
        return "formatnumber";
    }
}

