/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GetFunction
implements Function {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        int index = 1;
        String propertyName = null;
        ArrayList<Object> list = new ArrayList<Object>();
        if (dataList.size() == 1) {
            this.buildList(dataList.get(0), list);
        } else if (dataList.size() == 2) {
            this.buildList(dataList.get(0), list);
            index = this.buildIndex(dataList.get(1));
        } else if (dataList.size() == 3) {
            ObjectExpressionData exprData;
            Object obj;
            this.buildList(dataList.get(0), list);
            index = this.buildIndex(dataList.get(1));
            ExpressionData<?> d = dataList.get(2);
            if (d instanceof ObjectExpressionData && (obj = (exprData = (ObjectExpressionData)d).getData()) != null) {
                propertyName = obj.toString();
            }
        }
        Object obj = null;
        if (list.size() > 0) {
            obj = index <= list.size() ? list.get(index - 1) : list.get(list.size() - 1);
        }
        if (StringUtils.isNotBlank(propertyName)) {
            obj = Utils.getProperty(obj, propertyName);
        }
        return obj;
    }

    private int buildIndex(ExpressionData<?> d) {
        ObjectExpressionData exprData;
        Object obj;
        int index = 1;
        if (d instanceof ObjectExpressionData && (obj = (exprData = (ObjectExpressionData)d).getData()) != null) {
            index = Utils.toBigDecimal(obj).intValue();
        }
        return index;
    }

    private void buildList(ExpressionData<?> d, List<Object> list) {
        if (d instanceof ObjectExpressionData) {
            ObjectExpressionData exprData = (ObjectExpressionData)d;
            list.add(exprData.getData());
        } else if (d instanceof ObjectListExpressionData) {
            ObjectListExpressionData listData = (ObjectListExpressionData)d;
            list.addAll((Collection<Object>)listData.getData());
        } else if (d instanceof BindDataListExpressionData) {
            BindDataListExpressionData listData = (BindDataListExpressionData)d;
            Iterator iterator = listData.getData().iterator();
            while (iterator.hasNext()) {
                BindData bindData = (BindData)iterator.next();
                list.addAll(bindData.getDataList());
            }
        }
    }

    @Override
    public String name() {
        return "get";
    }
}

