/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.math;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.function.math.MathFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class MedianFunction
extends MathFunction {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        List<BigDecimal> list = this.buildDataList(dataList);
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        if (size == 2) {
            BigDecimal data = list.get(0).add(list.get(1));
            return data.divide(new BigDecimal(2), 8, 4);
        }
        Collections.sort(list);
        int mode = size % 2;
        if (mode == 0) {
            int half = size / 2;
            int start = half - 1;
            BigDecimal data = list.get(start).add(list.get(half));
            return data.divide(new BigDecimal(2), 8, 4);
        }
        int half = size / 2;
        return list.get(half);
    }

    @Override
    public String name() {
        return "median";
    }
}

