/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.math;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.function.math.MathFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.List;

public class StdevpFunction
extends MathFunction {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        List<BigDecimal> list = this.buildDataList(dataList);
        BigDecimal total = new BigDecimal(0);
        for (BigDecimal bigData : list) {
            total = total.add(bigData);
        }
        int size = list.size();
        BigDecimal avg = total.divide(new BigDecimal(size), 8, 4);
        double sum = 0.0;
        for (BigDecimal bigData : list) {
            BigDecimal data = bigData.subtract(avg);
            sum += Math.pow(data.doubleValue(), 2.0);
        }
        BigDecimal result = new BigDecimal(sum);
        result = result.divide(new BigDecimal(size), 8, 4);
        return Math.sqrt(result.doubleValue());
    }

    @Override
    public String name() {
        return "stdevp";
    }
}

