/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.condition;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.condition.BaseCondition;
import com.bstek.ureport.expression.model.condition.ConditionType;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.model.Cell;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class PropertyExpressionCondition
extends BaseCondition {
    private ConditionType type = ConditionType.property;
    @JsonIgnore
    private String leftProperty;
    @JsonIgnore
    private Expression rightExpression;

    @Override
    Object computeLeft(Cell cell, Cell currentCell, Object obj, Context context) {
        if (StringUtils.isNotBlank((CharSequence)this.leftProperty)) {
            return Utils.getProperty(obj, this.leftProperty);
        }
        return cell.getData();
    }

    @Override
    Object computeRight(Cell cell, Cell currentCell, Object obj, Context context) {
        ExpressionData<?> exprData = this.rightExpression.execute(cell, currentCell, context);
        return this.extractExpressionData(exprData);
    }

    @Override
    public ConditionType getType() {
        return this.type;
    }

    public void setLeftProperty(String leftProperty) {
        this.leftProperty = leftProperty;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }

    public String getLeftProperty() {
        return this.leftProperty;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }
}

