/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.set.CellExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class RelativeCellExpression
extends CellExpression {
    private static final long serialVersionUID = 8826396779392348224L;

    public RelativeCellExpression(String cellName) {
        super(cellName);
    }

    @Override
    public boolean supportPaging() {
        return false;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        List<Cell> targetCells = Utils.fetchTargetCells(currentCell, context, this.cellName);
        int size = targetCells.size();
        if (size == 0) {
            throw new ReportComputeException("Unknow cell " + this.cellName);
        }
        if (size == 1) {
            return new ObjectExpressionData(targetCells.get(0).getData());
        }
        Cell targetCell = null;
        for (Cell c : targetCells) {
            if (c.getRow() != currentCell.getRow() && c.getColumn() != currentCell.getColumn()) continue;
            targetCell = c;
            break;
        }
        if (targetCell != null) {
            return new ObjectExpressionData(targetCell.getData());
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Cell c : targetCells) {
            list.add(c.getData());
        }
        return new ObjectListExpressionData(list);
    }
}

