/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser;

import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.ColumnDefinition;
import com.bstek.ureport.definition.HeaderFooterDefinition;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.RowDefinition;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.searchform.SearchForm;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.exception.ReportParseException;
import com.bstek.ureport.parser.Parser;
import com.bstek.ureport.parser.impl.CellParser;
import com.bstek.ureport.parser.impl.ColumnParser;
import com.bstek.ureport.parser.impl.DatasourceParser;
import com.bstek.ureport.parser.impl.HeaderFooterParser;
import com.bstek.ureport.parser.impl.PaperParser;
import com.bstek.ureport.parser.impl.RowParser;
import com.bstek.ureport.parser.impl.searchform.SearchFormParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ReportParser {
    private Map<String, Parser<?>> parsers = new HashMap();

    public ReportParser() {
        this.parsers.put("row", new RowParser());
        this.parsers.put("column", new ColumnParser());
        this.parsers.put("cell", new CellParser());
        this.parsers.put("datasource", new DatasourceParser());
        this.parsers.put("paper", new PaperParser());
        this.parsers.put("header", new HeaderFooterParser());
        this.parsers.put("footer", new HeaderFooterParser());
        this.parsers.put("search-form", new SearchFormParser());
    }

    public ReportDefinition parse(InputStream inputStream, String file) {
        ReportDefinition report = new ReportDefinition();
        report.setReportFullName(file);
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(inputStream);
            Element element = document.getRootElement();
            if (!element.getName().equals("ureport")) {
                throw new ReportParseException("Unknow report file.");
            }
            ArrayList<RowDefinition> rows = new ArrayList<RowDefinition>();
            ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
            ArrayList<CellDefinition> cells = new ArrayList<CellDefinition>();
            ArrayList<DatasourceDefinition> datasources = new ArrayList<DatasourceDefinition>();
            report.setRows(rows);
            report.setColumns(columns);
            report.setCells(cells);
            report.setDatasources(datasources);
            for (Object obj : element.elements()) {
                if (obj == null || !(obj instanceof Element)) continue;
                Element ele = (Element)obj;
                Parser<?> parser = this.parsers.get(ele.getName());
                if (parser != null) {
                    Object target = parser.parse(ele);
                    if (target instanceof RowDefinition) {
                        rows.add((RowDefinition)target);
                        continue;
                    }
                    if (target instanceof ColumnDefinition) {
                        columns.add((ColumnDefinition)target);
                        continue;
                    }
                    if (target instanceof CellDefinition) {
                        cells.add((CellDefinition)target);
                        continue;
                    }
                    if (target instanceof DatasourceDefinition) {
                        datasources.add((DatasourceDefinition)target);
                        continue;
                    }
                    if (target instanceof Paper) {
                        Paper paper = (Paper)target;
                        report.setPaper(paper);
                        continue;
                    }
                    if (target instanceof HeaderFooterDefinition) {
                        HeaderFooterDefinition hf = (HeaderFooterDefinition)target;
                        if (ele.getName().equals("header")) {
                            report.setHeader(hf);
                            continue;
                        }
                        report.setFooter(hf);
                        continue;
                    }
                    if (!(target instanceof SearchForm)) continue;
                    SearchForm form = (SearchForm)target;
                    report.setSearchForm(form);
                    report.setSearchFormXml(ele.asXML());
                    continue;
                }
                throw new ReportParseException("Unknow element :" + ele.getName());
            }
            Collections.sort(rows);
            Collections.sort(columns);
        }
        catch (Exception ex) {
            throw new ReportParseException(ex);
        }
        this.rebuild(report);
        return report;
    }

    private void rebuild(ReportDefinition report) {
        List<CellDefinition> cells = report.getCells();
        HashMap<String, CellDefinition> cellsMap = new HashMap<String, CellDefinition>();
        HashMap<String, CellDefinition> cellsRowColMap = new HashMap<String, CellDefinition>();
        for (CellDefinition cell : cells) {
            int i;
            cellsMap.put(cell.getName(), cell);
            int rowNum = cell.getRowNumber();
            int colNum = cell.getColumnNumber();
            int rowSpan = cell.getRowSpan();
            int colSpan = cell.getColSpan();
            rowSpan = rowSpan > 0 ? rowSpan-- : 1;
            colSpan = colSpan > 0 ? colSpan-- : 1;
            int rowStart = rowNum;
            int rowEnd = rowNum + rowSpan;
            int colStart = colNum;
            int colEnd = colNum + colSpan;
            for (i = rowStart; i < rowEnd; ++i) {
                cellsRowColMap.put(i + "," + colNum, cell);
            }
            for (i = colStart; i < colEnd; ++i) {
                cellsRowColMap.put(rowNum + "," + i, cell);
            }
        }
        for (CellDefinition cell : cells) {
            CellDefinition targetCell;
            String topParentCellName;
            CellDefinition targetCell2;
            int rowNumber = cell.getRowNumber();
            int colNumber = cell.getColumnNumber();
            String leftParentCellName = cell.getLeftParentCellName();
            if (StringUtils.isNotBlank((CharSequence)leftParentCellName)) {
                if (!leftParentCellName.equals("root")) {
                    targetCell2 = (CellDefinition)cellsMap.get(leftParentCellName);
                    if (targetCell2 == null) {
                        throw new ReportException("Cell [" + cell.getName() + "] 's left parent cell [" + leftParentCellName + "] not exist.");
                    }
                    cell.setLeftParentCell(targetCell2);
                }
            } else if (colNumber > 1) {
                targetCell2 = (CellDefinition)cellsRowColMap.get(rowNumber + "," + (colNumber - 1));
                cell.setLeftParentCell(targetCell2);
            }
            if (StringUtils.isNotBlank((CharSequence)(topParentCellName = cell.getTopParentCellName()))) {
                if (topParentCellName.equals("root")) continue;
                targetCell = (CellDefinition)cellsMap.get(topParentCellName);
                if (targetCell == null) {
                    throw new ReportException("Cell [" + cell.getName() + "] 's top parent cell [" + topParentCellName + "] not exist.");
                }
                cell.setTopParentCell(targetCell);
                continue;
            }
            if (rowNumber <= 1) continue;
            targetCell = (CellDefinition)cellsRowColMap.get(rowNumber - 1 + "," + colNumber);
            cell.setTopParentCell(targetCell);
        }
    }
}

