/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser.impl.value;

import com.bstek.ureport.definition.Order;
import com.bstek.ureport.definition.mapping.MappingItem;
import com.bstek.ureport.definition.mapping.MappingType;
import com.bstek.ureport.definition.value.AggregateType;
import com.bstek.ureport.definition.value.DatasetValue;
import com.bstek.ureport.definition.value.GroupItem;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.Op;
import com.bstek.ureport.expression.model.condition.BaseCondition;
import com.bstek.ureport.expression.model.condition.Join;
import com.bstek.ureport.expression.model.condition.PropertyExpressionCondition;
import com.bstek.ureport.parser.impl.value.ValueParser;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class DatasetValueParser
extends ValueParser {
    @Override
    public Value parse(Element element) {
        String mappingType;
        DatasetValue value = new DatasetValue();
        value.setAggregate(AggregateType.valueOf(element.attributeValue("aggregate")));
        value.setDatasetName(element.attributeValue("dataset-name"));
        value.setProperty(element.attributeValue("property"));
        String order = element.attributeValue("order");
        if (StringUtils.isNotBlank((CharSequence)order)) {
            value.setOrder(Order.valueOf(order));
        }
        if (StringUtils.isNotBlank((CharSequence)(mappingType = element.attributeValue("mapping-type")))) {
            value.setMappingType(MappingType.valueOf(mappingType));
        }
        value.setMappingDataset(element.attributeValue("mapping-dataset"));
        value.setMappingKeyProperty(element.attributeValue("mapping-key-property"));
        value.setMappingValueProperty(element.attributeValue("mapping-value-property"));
        ArrayList<GroupItem> groupItems = null;
        ArrayList<Object> mappingItems = null;
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        PropertyExpressionCondition topCondition = null;
        BaseCondition prevCondition = null;
        value.setConditions(conditions);
        for (Object obj : element.elements()) {
            Object item;
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            if (ele.getName().equals("condition")) {
                PropertyExpressionCondition condition = this.parseCondition(ele);
                conditions.add(condition);
                if (topCondition == null) {
                    topCondition = condition;
                    prevCondition = topCondition;
                    continue;
                }
                prevCondition.setNextCondition(condition);
                prevCondition.setJoin(condition.getJoin());
                prevCondition = condition;
                continue;
            }
            if (ele.getName().equals("group-item")) {
                if (groupItems == null) {
                    groupItems = new ArrayList<GroupItem>();
                    value.setGroupItems(groupItems);
                }
                item = new GroupItem();
                ((GroupItem)item).setName(ele.attributeValue("name"));
                groupItems.add((GroupItem)item);
                PropertyExpressionCondition groupItemTopCondition = null;
                ArrayList<Condition> itemConditions = new ArrayList<Condition>();
                for (Object o : ele.elements()) {
                    if (o == null || !(o instanceof Element)) continue;
                    PropertyExpressionCondition itemCondition = this.parseCondition((Element)o);
                    itemConditions.add(itemCondition);
                    if (groupItemTopCondition == null) {
                        groupItemTopCondition = itemCondition;
                        continue;
                    }
                    groupItemTopCondition.setNextCondition(itemCondition);
                }
                ((GroupItem)item).setCondition(groupItemTopCondition);
                ((GroupItem)item).setConditions(itemConditions);
                continue;
            }
            if (!ele.getName().equals("mapping-item")) continue;
            item = new MappingItem();
            ((MappingItem)item).setLabel(ele.attributeValue("label"));
            ((MappingItem)item).setValue(ele.attributeValue("value"));
            if (mappingItems == null) {
                mappingItems = new ArrayList<Object>();
            }
            mappingItems.add(item);
        }
        if (topCondition != null) {
            value.setCondition(topCondition);
        }
        if (mappingItems != null) {
            value.setMappingItems(mappingItems);
        }
        return value;
    }

    private PropertyExpressionCondition parseCondition(Element ele) {
        String join;
        PropertyExpressionCondition condition = new PropertyExpressionCondition();
        String property = ele.attributeValue("property");
        condition.setLeftProperty(property);
        condition.setLeft(property);
        String operation = ele.attributeValue("op");
        condition.setOperation(operation);
        condition.setOp(Op.parse(operation));
        for (Object o : ele.elements()) {
            Element e;
            if (o == null || !(o instanceof Element) || !(e = (Element)o).getName().equals("value")) continue;
            String expr = e.getTextTrim();
            condition.setRightExpression(ExpressionUtils.parseExpression(expr));
            condition.setRight(expr);
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)(join = ele.attributeValue("join")))) {
            condition.setJoin(Join.valueOf(join));
        }
        return condition;
    }
}

