/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.utils;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.definition.value.DatasetValue;
import com.bstek.ureport.definition.value.ExpressionValue;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.JoinExpression;
import com.bstek.ureport.expression.model.expr.ParenExpression;
import com.bstek.ureport.expression.model.expr.dataset.DatasetExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class DataUtils {
    public static List<?> fetchData(Cell cell, Context context, String datasetName) {
        DatasetExpression de;
        Value value;
        Cell leftCell = DataUtils.fetchLeftCell(cell, context, datasetName);
        Cell topCell = DataUtils.fetchTopCell(cell, context, datasetName);
        List<Object> leftList = null;
        List<Object> topList = null;
        if (leftCell != null) {
            leftList = leftCell.getBindData();
        }
        if (topCell != null) {
            topList = topCell.getBindData();
        }
        if (leftList == null && topList == null) {
            List<?> data = context.getDatasetData(datasetName);
            return data;
        }
        if (leftList == null) {
            return topList;
        }
        if (topList == null) {
            return leftList;
        }
        List<Object> list = null;
        Object data = null;
        String prop = null;
        if (leftList.size() > topList.size()) {
            list = topList;
            data = leftCell.getData();
            value = leftCell.getValue();
            de = DataUtils.fetchDatasetExpression(value);
            if (de == null) {
                throw new ReportComputeException("Unsupport value : " + value);
            }
            prop = de.getProperty();
        } else {
            list = leftList;
            data = topCell.getData();
            value = topCell.getValue();
            de = DataUtils.fetchDatasetExpression(value);
            if (de == null) {
                throw new ReportComputeException("Unsupport value : " + value);
            }
            prop = de.getProperty();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : list) {
            Object o = Utils.getProperty(obj, prop);
            if (o == null && data == null) {
                result.add(obj);
                continue;
            }
            if (o != null && o.equals(data)) {
                result.add(obj);
                continue;
            }
            if (data == null || !data.equals(o)) continue;
            result.add(obj);
        }
        return result;
    }

    public static Cell fetchLeftCell(Cell cell, Context context, String datasetName) {
        String leftDatasetName;
        Value leftCellValue;
        DatasetExpression leftDSValue;
        Cell targetCell = null;
        Cell leftCell = cell.getLeftParentCell();
        if (leftCell != null && (leftDSValue = DataUtils.fetchDatasetExpression(leftCellValue = leftCell.getValue())) != null && (leftDatasetName = leftDSValue.getDatasetName()).equals(datasetName) && leftCell.getBindData() != null) {
            targetCell = leftCell;
        }
        return targetCell;
    }

    public static Cell fetchTopCell(Cell cell, Context context, String datasetName) {
        String leftDatasetName;
        Value topCellValue;
        DatasetExpression leftDSValue;
        Cell targetCell = null;
        Cell topCell = cell.getTopParentCell();
        if (topCell != null && (leftDSValue = DataUtils.fetchDatasetExpression(topCellValue = topCell.getValue())) != null && (leftDatasetName = leftDSValue.getDatasetName()).equals(datasetName) && topCell.getBindData() != null) {
            targetCell = topCell;
        }
        return targetCell;
    }

    public static DatasetExpression fetchDatasetExpression(Value value) {
        if (value instanceof ExpressionValue) {
            ExpressionValue exprValue = (ExpressionValue)value;
            Expression expr = exprValue.getExpression();
            if (expr instanceof DatasetExpression) {
                return (DatasetExpression)expr;
            }
            if (expr instanceof ParenExpression) {
                ParenExpression parenExpr = (ParenExpression)expr;
                DatasetExpression targetExpr = DataUtils.buildDatasetExpression(parenExpr);
                return targetExpr;
            }
            return null;
        }
        if (value instanceof DatasetValue) {
            return (DatasetValue)value;
        }
        return null;
    }

    private static DatasetExpression buildDatasetExpression(JoinExpression joinExpr) {
        List<BaseExpression> expressions = joinExpr.getExpressions();
        for (BaseExpression baseExpr : expressions) {
            if (baseExpr instanceof DatasetExpression) {
                return (DatasetExpression)baseExpr;
            }
            if (!(baseExpr instanceof JoinExpression)) continue;
            JoinExpression childExpr = (JoinExpression)baseExpr;
            return DataUtils.buildDatasetExpression(childExpr);
        }
        return null;
    }
}

