/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.enterprisedemands.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.enterprisedemands.domain.EnterpriseDemands;
import com.jeeplus.enterprisedemands.service.EnterpriseDemandsService;
import com.jeeplus.enterprisedemands.service.dto.EnterpriseDemandsDTO;
import com.jeeplus.enterprisedemands.service.mapstruct.EnterpriseDemandsWrapper;
import com.jeeplus.enterpriseinfo.service.EnterpriseInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4f01\u4e1a\u8bc9\u6c42"})
@RestController
@RequestMapping(value={"/enterprisedemands/enterpriseDemands"})
public class EnterpriseDemandsController {
    @Autowired
    private EnterpriseInfoService enterpriseInfoService;
    @Autowired
    private EnterpriseDemandsService enterpriseDemandsService;
    @Autowired
    private EnterpriseDemandsWrapper enterpriseDemandsWrapper;

    @ApiLog(value="\u67e5\u8be2\u4f01\u4e1a\u8bc9\u6c42\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u4f01\u4e1a\u8bc9\u6c42\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('enterprisedemands:enterpriseDemands:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<EnterpriseDemands>> list(EnterpriseDemandsDTO enterpriseDemandsDTO, Page<EnterpriseDemands> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)enterpriseDemandsDTO), EnterpriseDemandsDTO.class);
        IPage result = this.enterpriseDemandsService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u8bc9\u6c42\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u8bc9\u6c42\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('enterprisedemands:enterpriseDemands:view','enterprisedemands:enterpriseDemands:add','enterprisedemands:enterpriseDemands:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<EnterpriseDemandsDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.enterpriseDemandsWrapper.toDTO(this.enterpriseDemandsService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u6839\u636euserid\u83b7\u53d6\u4f01\u4e1a\u5bf9\u5e94\u6570\u636e")
    @ApiOperation(value="\u6839\u636euserid\u83b7\u53d6\u4f01\u4e1a\u5bf9\u5e94\u6570\u636e")
    @GetMapping(value={"queryQyById"})
    public ResponseEntity<String> queryQyById(String userid) {
        String res = "";
        String tp = this.enterpriseInfoService.getOfficeBuildTypeforuserid(userid);
        if (tp == null || !tp.equals("1")) {
            if (tp != null && tp.equals("2")) {
                HashMap<String, Object> res2 = this.enterpriseInfoService.getLyinfoforuserid(userid);
                res = res2.get("building_name").toString() + "-" + res2.get("building_contacts").toString() + "-" + res2.get("building_phone").toString();
            } else if (tp != null && tp.equals("3")) {
                HashMap<String, Object> res2 = this.enterpriseInfoService.getQyinfoforuserid(userid);
                res = res2.get("building_name").toString() + "-" + res2.get("name").toString() + "-" + res2.get("floor").toString();
            }
        }
        return ResponseEntity.ok((Object)res);
    }

    @ApiLog(value="\u4fdd\u5b58\u4f01\u4e1a\u8bc9\u6c42")
    @ApiOperation(value="\u4fdd\u5b58\u4f01\u4e1a\u8bc9\u6c42")
    @PreAuthorize(value="hasAnyAuthority('enterprisedemands:enterpriseDemands:add','enterprisedemands:enterpriseDemands:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody EnterpriseDemandsDTO enterpriseDemandsDTO) {
        if (enterpriseDemandsDTO.getId() == null || enterpriseDemandsDTO.getId().equals("")) {
            enterpriseDemandsDTO.setState("1");
        }
        this.enterpriseDemandsService.saveOrUpdate(this.enterpriseDemandsWrapper.toEntity((Object)enterpriseDemandsDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u4f01\u4e1a\u8bc9\u6c42\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u4f01\u4e1a\u8bc9\u6c42")
    @ApiOperation(value="\u5220\u9664\u4f01\u4e1a\u8bc9\u6c42")
    @PreAuthorize(value="hasAuthority('enterprisedemands:enterpriseDemands:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.enterpriseDemandsService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u4f01\u4e1a\u8bc9\u6c42\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u4f01\u4e1a\u8bc9\u6c42\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('enterprisedemands:enterpriseDemands:export')")
    @GetMapping(value={"export"})
    public void exportFile(EnterpriseDemandsDTO enterpriseDemandsDTO, Page<EnterpriseDemands> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)enterpriseDemandsDTO), EnterpriseDemandsDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = ((Page)this.enterpriseDemandsService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        EasyExcelUtils.newInstance((IService)this.enterpriseDemandsService, (EntityWrapper)this.enterpriseDemandsWrapper).exportExcel(result, options.getSheetName(), EnterpriseDemandsDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('enterprisedemands:enterpriseDemands:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.enterpriseDemandsService, (EntityWrapper)this.enterpriseDemandsWrapper).importExcel(file, EnterpriseDemandsDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('enterprisedemands:enterpriseDemands:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u4f01\u4e1a\u8bc9\u6c42\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.enterpriseDemandsService, (EntityWrapper)this.enterpriseDemandsWrapper).exportExcel((List)list, "\u4f01\u4e1a\u8bc9\u6c42\u6570\u636e", EnterpriseDemandsDTO.class, fileName, null, response);
    }
}

