/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.security.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);

    public static Authentication login(String username, String password, AuthenticationManager authenticationManager) throws AuthenticationException {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        Authentication authentication = authenticationManager.authenticate((Authentication)token);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return authentication;
    }

    public static Authentication getAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof AnonymousAuthenticationToken)) {
            return authentication;
        }
        return null;
    }

    public static String getToken() {
        Authentication authentication = SecurityUtils.getAuthentication();
        return authentication != null ? authentication.getCredentials().toString() : null;
    }

    public static String getLoginName() {
        Authentication authentication = SecurityUtils.getAuthentication();
        return authentication != null ? authentication.getName() : null;
    }

    public static String encryptPassword(String password) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.encode((CharSequence)password);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.matches((CharSequence)plainPassword, password);
    }
}

