/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.security.util.SecurityUtils;
import com.jeeplus.sys.domain.User;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.service.mapstruct.UserWrapper;
import com.jeeplus.sys.utils.DictUtils;
import com.jeeplus.sys.utils.MenuUtils;
import com.jeeplus.sys.utils.RouterUtils;
import com.jeeplus.sys.utils.UserUtils;
import com.jeeplus.sys.utils.excel.UserEasyExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/user"})
public class UserController {
    @Autowired
    private UserService userService;

    @ApiLog(value="\u67e5\u8be2\u7528\u6237")
    @GetMapping(value={"queryById"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237")
    public ResponseEntity queryById(@RequestParam(value="id") String id) {
        UserDTO userDTO = this.userService.get(id);
        return ResponseEntity.ok((Object)userDTO);
    }

    @ApiLog(value="\u7528\u6237\u6570\u636e\u5217\u8868")
    @ApiOperation(value="\u7528\u6237\u6570\u636e\u5217\u8868")
    @PreAuthorize(value="hasAuthority('sys:user:list')")
    @GetMapping(value={"list"})
    public ResponseEntity list(UserDTO userDTO, Page<UserDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)userDTO, UserDTO.class);
        IPage<UserDTO> result = this.userService.findPage(page, queryWrapper);
        if (result.getRecords() != null && result.getRecords().size() > 0) {
            for (int i = 0; i < result.getRecords().size(); ++i) {
                String id = ((UserDTO)result.getRecords().get(i)).getId();
                UserDTO userDTO2 = this.userService.get(id);
                ((UserDTO)result.getRecords().get(i)).setRoleDTOList(userDTO2.getRoleDTOList());
            }
        }
        return ResponseEntity.ok(result);
    }

    @DemoMode
    @ApiLog(value="\u4fdd\u5b58\u7528\u6237")
    @PreAuthorize(value="hasAnyAuthority('sys:user:add', 'sys:user:edit')")
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237")
    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody UserDTO userDTO) {
        if (StrUtil.isNotBlank((CharSequence)userDTO.getNewPassword())) {
            userDTO.setPassword(SecurityUtils.encryptPassword(userDTO.getNewPassword()));
        }
        if (!UserUtils.isCheckLoginName(userDTO.getOldLoginName(), userDTO.getLoginName())) {
            return ResponseEntity.badRequest().body((Object)("\u4fdd\u5b58\u7528\u6237'" + userDTO.getLoginName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u540d\u5df2\u5b58\u5728!"));
        }
        this.userService.saveOrUpdate(userDTO);
        return ResponseEntity.ok((Object)("\u4fdd\u5b58\u7528\u6237'" + userDTO.getLoginName() + "'\u6210\u529f!"));
    }

    @ApiLog(value="\u4fee\u6539\u4e2a\u4eba\u8d44\u6599")
    @ApiOperation(value="\u4fee\u6539\u4e2a\u4eba\u8d44\u6599")
    @PostMapping(value={"saveInfo"})
    public ResponseEntity saveInfo(@RequestBody UserDTO userDTO) {
        this.userService.updateById(UserWrapper.INSTANCE.toEntity(userDTO));
        UserUtils.deleteCache(UserUtils.getCurrentUserDTO());
        return ResponseEntity.ok((Object)"\u4fee\u6539\u4e2a\u4eba\u8d44\u6599\u6210\u529f!");
    }

    @DemoMode
    @ApiLog(value="\u5220\u9664\u7528\u6237")
    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    @PreAuthorize(value="hasAuthority('sys:user:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String ids) {
        String[] idArray = ids.split(",");
        StringBuffer msg = new StringBuffer();
        boolean success = true;
        for (String id : idArray) {
            UserDTO userDTO = this.userService.get(id);
            if (UserUtils.getCurrentUserDTO().getId().equals(userDTO.getId())) {
                success = false;
                msg.append("[" + userDTO.getLoginName() + "]\u5220\u9664\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5f53\u524d\u7528\u6237!<br/>");
                continue;
            }
            if (userDTO.isAdmin()) {
                success = false;
                msg.append("[" + userDTO.getLoginName() + "]\u5220\u9664\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u8d85\u7ea7\u7ba1\u7406\u5458!<br/>");
                continue;
            }
            msg.append("[" + userDTO.getLoginName() + "]\u5220\u9664\u6210\u529f!<br/>");
            this.userService.deleteUser(userDTO);
        }
        if (success) {
            return ResponseEntity.ok((Object)msg.toString());
        }
        return ResponseEntity.badRequest().body((Object)msg.toString());
    }

    @ApiLog(value="\u5bfc\u51fa\u7528\u6237\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('sys:user:export')")
    @GetMapping(value={"export"})
    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237excel")
    public void exportFile(UserDTO userDTO, Page<UserDTO> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        List result;
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)userDTO, UserDTO.class);
        if ("current".equals(options.getMode())) {
            result = this.userService.findPage(page, queryWrapper).getRecords();
        } else if ("selected".equals(options.getMode())) {
            queryWrapper.in((Object)"a.id", options.getSelectIds());
            result = this.userService.findPage(page, queryWrapper).getRecords();
        } else {
            page.setSize(-1L);
            page.setCurrent(0L);
            result = this.userService.findPage(page, queryWrapper).getRecords();
        }
        UserEasyExcel.newInstance().exportExcel(result, options.getSheetName(), UserDTO.class, fileName, options.getExportFields(), response);
    }

    @DemoMode
    @PreAuthorize(value="hasAnyAuthority('sys:user:import')")
    @PostMapping(value={"import"})
    @ApiOperation(value="\u5bfc\u5165\u7528\u6237excel")
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = UserEasyExcel.newInstance(this.userService, UserWrapper.INSTANCE).importExcel(file, UserDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('sys:user:import')")
    @GetMapping(value={"import/template"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u7528\u6237\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        list.add(UserUtils.getCurrentUserDTO());
        UserEasyExcel.newInstance().exportExcel(list, "\u7528\u6237\u6570\u636e", UserDTO.class, fileName, null, response);
    }

    @ApiLog(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"info"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    public ResponseEntity infoData() {
        return ResponseUtil.newInstance().add("role", UserUtils.getRoleDTOList()).add("user", (Object)UserUtils.getCurrentUserDTO()).ok("\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f\u6210\u529f!");
    }

    @DemoMode
    @ApiLog(value="\u4fee\u6539\u5bc6\u7801")
    @RequestMapping(value={"savePwd"})
    public ResponseEntity savePwd(String oldPassword, String newPassword) {
        UserDTO userDTO = UserUtils.getCurrentUserDTO();
        if (StrUtil.isNotBlank((CharSequence)oldPassword) && StrUtil.isNotBlank((CharSequence)newPassword)) {
            if (SecurityUtils.validatePassword(oldPassword, userDTO.getPassword())) {
                User user = new User(userDTO.getId());
                user.setPassword(SecurityUtils.encryptPassword(newPassword));
                this.userService.updateById(user);
                UserUtils.deleteCache(userDTO);
                return ResponseEntity.ok((Object)"\u4fee\u6539\u5bc6\u7801\u6210\u529f\uff01");
            }
            return ResponseEntity.badRequest().body((Object)"\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u65e7\u5bc6\u7801\u9519\u8bef\uff01");
        }
        return ResponseEntity.badRequest().body((Object)"\u53c2\u6570\u9519\u8bef\uff01");
    }

    @ApiLog(value="\u83b7\u53d6\u7528\u6237\u83dc\u5355")
    @GetMapping(value={"getMenus"})
    public ResponseEntity getMenus() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dictList", DictUtils.getDictMap());
        map.put("permissions", UserUtils.getPermissions());
        map.put("menuList", MenuUtils.getMenus());
        map.put("routerList", RouterUtils.getRoutersByMenu());
        String res = new Gson().toJson(map);
        return ResponseEntity.ok((Object)res);
    }
}

