/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.utils.excel;

import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.extension.service.IService;
import com.jeeplus.common.beanvalidator.BeanValidators;
import com.jeeplus.core.excel.ExcelListener;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.security.util.SecurityUtils;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.utils.UserUtils;
import java.util.List;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserExcelListener
extends ExcelListener<UserDTO> {
    private static final Logger log = LoggerFactory.getLogger(UserExcelListener.class);

    public UserExcelListener(IService service, EntityWrapper wrapper) {
        super(service, wrapper);
    }

    @Override
    public void saveData() {
        try {
            int successNum = 0;
            int failureNum = 0;
            StringBuilder failureMsg = new StringBuilder();
            List list = this.getCachedDataList();
            for (UserDTO user : list) {
                try {
                    if (UserUtils.isCheckLoginName("", user.getLoginName())) {
                        user.setPassword(SecurityUtils.encryptPassword("123456"));
                        Validator validator = (Validator)SpringUtil.getBean(Validator.class);
                        BeanValidators.validateWithException((Validator)validator, (Object)user, (Class[])new Class[0]);
                        ((UserService)this.getService()).saveOrUpdate(user);
                        ++successNum;
                    } else {
                        failureMsg.append("<br/>\u767b\u5f55\u540d " + user.getLoginName() + " \u5df2\u5b58\u5728; ");
                        ++failureNum;
                    }
                }
                catch (ConstraintViolationException ex) {
                    failureMsg.append("<br/>\u767b\u5f55\u540d " + user.getLoginName() + " \u5bfc\u5165\u5931\u8d25\uff1a");
                    List messageList = BeanValidators.extractPropertyAndMessageAsList((ConstraintViolationException)ex, (String)": ");
                    for (String message : messageList) {
                        failureMsg.append(message + "; ");
                        ++failureNum;
                    }
                }
                catch (Exception ex) {
                    ++failureNum;
                    failureMsg.append("<br/>\u767b\u5f55\u540d " + user.getLoginName() + " \u5bfc\u5165\u5931\u8d25\uff1a" + ex.getMessage());
                }
                if (failureNum <= 0) continue;
                failureMsg.insert(0, "\uff0c\u5931\u8d25 " + failureNum + " \u6761\u7528\u6237\uff0c\u5bfc\u5165\u4fe1\u606f\u5982\u4e0b\uff1a");
            }
            this.setMessage("\u5df2\u6210\u529f\u5bfc\u5165 " + successNum + " \u6761\u7528\u6237" + failureMsg);
            log.info(this.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setMessage("\u5bfc\u5165\u7528\u6237\u5931\u8d25\uff01\u5931\u8d25\u4fe1\u606f\uff1a" + e.getMessage());
            log.info(this.getMessage());
        }
    }
}

