/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.query;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jeeplus.common.utils.RequestUtils;
import com.jeeplus.core.query.Query;
import com.jeeplus.core.query.QueryType;
import java.lang.reflect.Field;
import org.apache.commons.beanutils.PropertyUtils;

public class QueryWrapperGenerator {
    public static <T> QueryWrapper<T> buildQueryCondition(T searchObj, Class<T> entityClass) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        Field[] fields = ReflectUtil.getFields(entityClass);
        block14: for (int i = 0; i < fields.length; ++i) {
            Object value;
            String fieldName;
            Field field = fields[i];
            if (!field.isAnnotationPresent(Query.class)) continue;
            Query annotation = field.getAnnotation(Query.class);
            String column = StrUtil.isNotBlank((CharSequence)annotation.tableColumn()) ? annotation.tableColumn() : StrUtil.toUnderlineCase((CharSequence)field.getName());
            String string = fieldName = StrUtil.isNotBlank((CharSequence)annotation.javaField()) ? annotation.javaField() : field.getName();
            if (PropertyUtils.getNestedProperty(searchObj, (String)field.getName()) == null && !annotation.type().equals((Object)QueryType.BETWEEN) || ((value = PropertyUtils.getNestedProperty(searchObj, (String)fieldName)) == null || !StrUtil.isNotBlank((CharSequence)value.toString())) && !annotation.type().equals((Object)QueryType.BETWEEN)) continue;
            switch (annotation.type()) {
                case EQ: {
                    queryWrapper.eq((Object)column, value);
                    continue block14;
                }
                case NE: {
                    queryWrapper.ne((Object)column, value);
                    continue block14;
                }
                case GT: {
                    queryWrapper.gt((Object)column, value);
                    continue block14;
                }
                case GE: {
                    queryWrapper.ge((Object)column, value);
                    continue block14;
                }
                case LT: {
                    queryWrapper.lt((Object)column, value);
                    continue block14;
                }
                case LE: {
                    queryWrapper.le((Object)column, value);
                    continue block14;
                }
                case BETWEEN: {
                    String begin = RequestUtils.getRequest().getParameter("begin" + StrUtil.upperFirst((CharSequence)fieldName));
                    String end = RequestUtils.getRequest().getParameter("end" + StrUtil.upperFirst((CharSequence)fieldName));
                    if (begin == null || !StrUtil.isNotBlank((CharSequence)begin.toString()) || end == null || !StrUtil.isNotBlank((CharSequence)end.toString())) continue block14;
                    queryWrapper.between((Object)column, (Object)begin, (Object)end);
                    continue block14;
                }
                case NOTBETWEEN: {
                    String begin = RequestUtils.getRequest().getParameter("begin" + StrUtil.upperFirst((CharSequence)fieldName));
                    String end = RequestUtils.getRequest().getParameter("end" + StrUtil.upperFirst((CharSequence)fieldName));
                    if (begin == null || !StrUtil.isNotBlank((CharSequence)begin.toString()) || end == null || !StrUtil.isNotBlank((CharSequence)end.toString())) continue block14;
                    queryWrapper.notBetween((Object)column, (Object)begin, (Object)end);
                    continue block14;
                }
                case LIKE: {
                    queryWrapper.like((Object)column, value);
                    continue block14;
                }
                case NOTLIKE: {
                    queryWrapper.notLike((Object)column, value);
                    continue block14;
                }
                case LIKELEFT: {
                    queryWrapper.likeLeft((Object)column, value);
                    continue block14;
                }
                case LIKERIGHT: {
                    queryWrapper.likeRight((Object)column, value);
                    continue block14;
                }
                default: {
                    queryWrapper.like((Object)column, value);
                }
            }
        }
        return queryWrapper;
    }
}

