/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.notify.service.dto;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.Query;
import com.jeeplus.core.query.QueryType;
import com.jeeplus.core.service.dto.BaseDTO;
import com.jeeplus.notify.service.dto.NotifyRecordDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Size;

public class NotifyDTO
extends BaseDTO {
    private static final long serialVersionUID = 1L;
    @Query(type=QueryType.EQ)
    @Size(min=0, max=1, message="\u7c7b\u578b\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 1 \u4e4b\u95f4")
    private @Size(min=0, max=1, message="\u7c7b\u578b\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 1 \u4e4b\u95f4") String type;
    @Query
    @Size(min=0, max=200, message="\u6807\u9898\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 200 \u4e4b\u95f4")
    private @Size(min=0, max=200, message="\u6807\u9898\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 200 \u4e4b\u95f4") String title;
    private String content;
    @Size(min=0, max=2000, message="\u9644\u4ef6\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 2000 \u4e4b\u95f4")
    private @Size(min=0, max=2000, message="\u9644\u4ef6\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 2000 \u4e4b\u95f4") String files;
    @Query(type=QueryType.EQ)
    @Size(min=0, max=1, message="\u72b6\u6001\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 1 \u4e4b\u95f4")
    private @Size(min=0, max=1, message="\u72b6\u6001\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 1 \u4e4b\u95f4") String status;
    private String readNum;
    private String unReadNum;
    private boolean isSelf;
    @Query(type=QueryType.EQ)
    private String readFlag;
    private List<NotifyRecordDTO> notifyRecordDTOList = Lists.newArrayList();

    public String getNotifyRecordIds() {
        return this.notifyRecordDTOList.stream().map(notifyRecordDTO -> notifyRecordDTO.getUserDTO().getId()).collect(Collectors.joining(","));
    }

    public void setNotifyRecordIds(String notifyRecordIds) {
        this.notifyRecordDTOList = Lists.newArrayList();
        for (String id : StrUtil.split((CharSequence)notifyRecordIds, (CharSequence)",")) {
            NotifyRecordDTO dto = new NotifyRecordDTO();
            dto.setNotifyDTO(this);
            dto.setUserDTO(new UserDTO(id));
            dto.setReadFlag("0");
            this.notifyRecordDTOList.add(dto);
        }
    }

    public String getNotifyRecordNames() {
        return this.notifyRecordDTOList.stream().map(notifyRecordDTO -> notifyRecordDTO.getUserDTO().getName()).collect(Collectors.joining(","));
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public String getFiles() {
        return this.files;
    }

    public String getStatus() {
        return this.status;
    }

    public String getReadNum() {
        return this.readNum;
    }

    public String getUnReadNum() {
        return this.unReadNum;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public String getReadFlag() {
        return this.readFlag;
    }

    public List<NotifyRecordDTO> getNotifyRecordDTOList() {
        return this.notifyRecordDTOList;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFiles(String files) {
        this.files = files;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setReadNum(String readNum) {
        this.readNum = readNum;
    }

    public void setUnReadNum(String unReadNum) {
        this.unReadNum = unReadNum;
    }

    public void setSelf(boolean isSelf) {
        this.isSelf = isSelf;
    }

    public void setReadFlag(String readFlag) {
        this.readFlag = readFlag;
    }

    public void setNotifyRecordDTOList(List<NotifyRecordDTO> notifyRecordDTOList) {
        this.notifyRecordDTOList = notifyRecordDTOList;
    }

    public String toString() {
        return "NotifyDTO(type=" + this.getType() + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", files=" + this.getFiles() + ", status=" + this.getStatus() + ", readNum=" + this.getReadNum() + ", unReadNum=" + this.getUnReadNum() + ", isSelf=" + this.isSelf() + ", readFlag=" + this.getReadFlag() + ", notifyRecordDTOList=" + this.getNotifyRecordDTOList() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotifyDTO)) {
            return false;
        }
        NotifyDTO other = (NotifyDTO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSelf() != other.isSelf()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$files = this.getFiles();
        String other$files = other.getFiles();
        if (this$files == null ? other$files != null : !this$files.equals(other$files)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$readNum = this.getReadNum();
        String other$readNum = other.getReadNum();
        if (this$readNum == null ? other$readNum != null : !this$readNum.equals(other$readNum)) {
            return false;
        }
        String this$unReadNum = this.getUnReadNum();
        String other$unReadNum = other.getUnReadNum();
        if (this$unReadNum == null ? other$unReadNum != null : !this$unReadNum.equals(other$unReadNum)) {
            return false;
        }
        String this$readFlag = this.getReadFlag();
        String other$readFlag = other.getReadFlag();
        if (this$readFlag == null ? other$readFlag != null : !this$readFlag.equals(other$readFlag)) {
            return false;
        }
        List<NotifyRecordDTO> this$notifyRecordDTOList = this.getNotifyRecordDTOList();
        List<NotifyRecordDTO> other$notifyRecordDTOList = other.getNotifyRecordDTOList();
        return !(this$notifyRecordDTOList == null ? other$notifyRecordDTOList != null : !((Object)this$notifyRecordDTOList).equals(other$notifyRecordDTOList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotifyDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSelf() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : $files.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $readNum = this.getReadNum();
        result = result * 59 + ($readNum == null ? 43 : $readNum.hashCode());
        String $unReadNum = this.getUnReadNum();
        result = result * 59 + ($unReadNum == null ? 43 : $unReadNum.hashCode());
        String $readFlag = this.getReadFlag();
        result = result * 59 + ($readFlag == null ? 43 : $readFlag.hashCode());
        List<NotifyRecordDTO> $notifyRecordDTOList = this.getNotifyRecordDTOList();
        result = result * 59 + ($notifyRecordDTOList == null ? 43 : ((Object)$notifyRecordDTOList).hashCode());
        return result;
    }
}

