/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import com.google.common.collect.Lists;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.sys.domain.Area;
import com.jeeplus.sys.service.AreaService;
import com.jeeplus.sys.service.dto.AreaDTO;
import com.jeeplus.sys.service.mapstruct.AreaWrapper;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/area"})
public class AreaController {
    @Autowired
    private AreaService areaService;
    @Autowired
    private AreaWrapper areaWrapper;

    @ApiLog(value="\u67e5\u8be2\u533a\u57df\u5217\u8868")
    @PreAuthorize(value="hasAuthority('sys:area:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<List<Area>> list() {
        return ResponseEntity.ok().body(this.areaService.findAll());
    }

    @ApiLog(value="\u67e5\u8be2\u533a\u57df")
    @PreAuthorize(value="hasAnyAuthority('sys:area:view', 'sys:area:add', 'sys:area:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<AreaDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.areaWrapper.toDTO(this.areaService.getById((Serializable)((Object)id))));
    }

    @DemoMode
    @ApiLog(value="\u4fdd\u5b58\u533a\u57df")
    @PreAuthorize(value="hasAnyAuthority('sys:area:add', 'sys:area:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@RequestBody AreaDTO areaDTO) {
        this.areaService.saveOrUpdate((Area)this.areaWrapper.toEntity(areaDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @DemoMode
    @ApiLog(value="\u5220\u9664\u533a\u57df")
    @PreAuthorize(value="hasAuthority('sys:area:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.areaService.removeWithChildrenByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u533a\u57df\u6210\u529f\uff01");
    }

    @ApiLog(value="\u83b7\u53d6\u533a\u57df\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity<List<Area>> treeData(@RequestParam(required=false) String extId) {
        List rootTree = this.areaService.treeData(extId);
        return ResponseEntity.ok(rootTree);
    }
}

