/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.enterpriseproperty.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.enterpriseinfo.service.EnterpriseInfoService;
import com.jeeplus.enterpriseproperty.domain.EnterpriseProperty;
import com.jeeplus.enterpriseproperty.service.EnterprisePropertyService;
import com.jeeplus.enterpriseproperty.service.dto.EnterprisePropertyDTO;
import com.jeeplus.enterpriseproperty.service.mapstruct.EnterprisePropertyWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4f01\u4e1a\u7269\u4e1a\u8d39"})
@RestController
@RequestMapping(value={"/enterpriseproperty/enterpriseProperty"})
public class EnterprisePropertyController {
    @Autowired
    private EnterprisePropertyService enterprisePropertyService;
    @Autowired
    private EnterprisePropertyWrapper enterprisePropertyWrapper;
    @Autowired
    private EnterpriseInfoService enterpriseInfoService;

    @ApiLog(value="\u67e5\u8be2\u4f01\u4e1a\u7269\u4e1a\u8d39\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u4f01\u4e1a\u7269\u4e1a\u8d39\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('enterpriseproperty:enterpriseProperty:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<EnterprisePropertyDTO>> list(EnterprisePropertyDTO enterprisePropertyDTO, Page<EnterprisePropertyDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)enterprisePropertyDTO), EnterprisePropertyDTO.class);
        IPage<EnterprisePropertyDTO> result = this.enterprisePropertyService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u7269\u4e1a\u8d39\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u7269\u4e1a\u8d39\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('enterpriseproperty:enterpriseProperty:view','enterpriseproperty:enterpriseProperty:add','enterpriseproperty:enterpriseProperty:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<EnterprisePropertyDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.enterprisePropertyWrapper.toDTO(this.enterprisePropertyService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u4f01\u4e1a\u7269\u4e1a\u8d39")
    @ApiOperation(value="\u4fdd\u5b58\u4f01\u4e1a\u7269\u4e1a\u8d39")
    @PreAuthorize(value="hasAnyAuthority('enterpriseproperty:enterpriseProperty:add','enterpriseproperty:enterpriseProperty:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody EnterprisePropertyDTO enterprisePropertyDTO) {
        this.enterprisePropertyService.saveOrUpdate(this.enterprisePropertyWrapper.toEntity((Object)enterprisePropertyDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u4f01\u4e1a\u7269\u4e1a\u8d39\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u4f01\u4e1a\u7269\u4e1a\u8d39")
    @ApiOperation(value="\u5220\u9664\u4f01\u4e1a\u7269\u4e1a\u8d39")
    @PreAuthorize(value="hasAuthority('enterpriseproperty:enterpriseProperty:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.enterprisePropertyService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u4f01\u4e1a\u7269\u4e1a\u8d39\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u4f01\u4e1a\u7269\u4e1a\u8d39\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('enterpriseproperty:enterpriseProperty:export')")
    @GetMapping(value={"export"})
    public void exportFile(EnterprisePropertyDTO enterprisePropertyDTO, Page<EnterpriseProperty> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)enterprisePropertyDTO), EnterprisePropertyDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = ((Page)this.enterprisePropertyService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        EasyExcelUtils.newInstance((IService)this.enterprisePropertyService, (EntityWrapper)this.enterprisePropertyWrapper).exportExcel(result, options.getSheetName(), EnterprisePropertyDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('enterpriseproperty:enterpriseProperty:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.enterprisePropertyService, (EntityWrapper)this.enterprisePropertyWrapper).importExcel(file, EnterprisePropertyDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('enterpriseproperty:enterpriseProperty:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u4f01\u4e1a\u7269\u4e1a\u8d39\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.enterprisePropertyService, (EntityWrapper)this.enterprisePropertyWrapper).exportExcel((List)list, "\u4f01\u4e1a\u7269\u4e1a\u8d39\u6570\u636e", EnterprisePropertyDTO.class, fileName, null, response);
    }
}

