/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.sys.domain.Post;
import com.jeeplus.sys.service.PostService;
import com.jeeplus.sys.service.dto.PostDTO;
import com.jeeplus.sys.service.mapstruct.PostWrapper;
import java.io.Serializable;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/post"})
public class PostController {
    @Autowired
    private PostService postService;

    @PreAuthorize(value="hasAuthority('sys:post:list')")
    @GetMapping(value={"list"})
    public ResponseEntity list(Post post, Page<Post> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)post, Post.class);
        IPage result = this.postService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('sys:post:view','sys:post:add','sys:post:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(String id) {
        Post post = (Post)this.postService.getById((Serializable)((Object)id));
        return ResponseEntity.ok((Object)PostWrapper.INSTANCE.toDTO(post));
    }

    @PreAuthorize(value="hasAnyAuthority('sys:post:add','sys:post:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody PostDTO postDTO) {
        Post post = (Post)PostWrapper.INSTANCE.toEntity(postDTO);
        this.postService.saveOrUpdate(post);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5c97\u4f4d\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('sys:post:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String ids) {
        Object[] idArray = ids.split(",");
        this.postService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5c97\u4f4d\u6210\u529f");
    }
}

