/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.quartz.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.quartz.domain.ScheduleJob;
import com.jeeplus.quartz.mapper.ScheduleJobMapper;
import java.io.Serializable;
import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ScheduleJobService
extends ServiceImpl<ScheduleJobMapper, ScheduleJob> {
    @Autowired
    private Scheduler scheduler;

    @Transactional
    public boolean saveOrUpdate(ScheduleJob scheduleJob) {
        if (StrUtil.isNotBlank((CharSequence)scheduleJob.getId())) {
            ScheduleJob t = (ScheduleJob)((Object)super.getById((Serializable)((Object)scheduleJob.getId())));
            JobKey key = new JobKey(t.getName(), t.getJobGroup());
            try {
                this.scheduler.deleteJob(key);
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        }
        this.add(scheduleJob);
        return super.saveOrUpdate((Object)scheduleJob);
    }

    @Transactional
    public void add(ScheduleJob scheduleJob) {
        Class<?> job = null;
        try {
            job = Class.forName(scheduleJob.getClassName());
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        JobDetail jobDetail = JobBuilder.newJob(job).withIdentity(scheduleJob.getName(), scheduleJob.getJobGroup()).build();
        jobDetail.getJobDataMap().put("scheduleJob", (Object)scheduleJob);
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression());
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(scheduleJob.getName(), scheduleJob.getJobGroup()).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        ((CronTriggerImpl)trigger).setStartTime(new Date());
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            JobKey key = new JobKey(scheduleJob.getName(), scheduleJob.getJobGroup());
            if (scheduleJob.getStatus().equals("0")) {
                this.scheduler.pauseJob(key);
            } else {
                this.scheduler.resumeJob(key);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Transactional(readOnly=false)
    public void delete(ScheduleJob scheduleJob) {
        JobKey jobKey = new JobKey(scheduleJob.getName(), scheduleJob.getJobGroup());
        try {
            this.scheduler.pauseJob(jobKey);
            this.scheduler.deleteJob(jobKey);
            super.removeById((Serializable)((Object)scheduleJob.getId()));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public void stopJob(ScheduleJob scheduleJob) {
        JobKey key = new JobKey(scheduleJob.getName(), scheduleJob.getJobGroup());
        try {
            this.scheduler.pauseJob(key);
            scheduleJob.setStatus("0");
            super.updateById((Object)scheduleJob);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public void restartJob(ScheduleJob scheduleJob) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)scheduleJob.getName(), (String)scheduleJob.getJobGroup());
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                this.add(scheduleJob);
            }
            JobKey key = new JobKey(scheduleJob.getName(), scheduleJob.getJobGroup());
            this.scheduler.resumeJob(key);
            scheduleJob.setStatus("1");
            super.updateById((Object)scheduleJob);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public void startNowJob(ScheduleJob scheduleJob) {
        JobKey key = new JobKey(scheduleJob.getName(), scheduleJob.getJobGroup());
        try {
            this.scheduler.triggerJob(key);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}

