/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.buildinginfo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.buildinginfo.domain.BuildingManagement;
import com.jeeplus.buildinginfo.service.BuildingManagementService;
import com.jeeplus.buildinginfo.service.dto.BuildingManagementDTO;
import com.jeeplus.buildinginfo.service.mapstruct.BuildingManagementWrapper;
import com.jeeplus.core.domain.TreeEntity;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.enterpriseinfo.service.EnterpriseInfoService;
import com.jeeplus.parkmanagement.domain.ParkManagement;
import com.jeeplus.parkmanagement.service.ParkManagementService;
import com.jeeplus.security.util.SecurityUtils;
import com.jeeplus.sys.domain.Office;
import com.jeeplus.sys.service.OfficeService;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.OfficeDTO;
import com.jeeplus.sys.service.dto.RoleDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.utils.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u697c\u5b87\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/buildinginfo/buildingManagement"})
public class BuildingManagementController {
    @Autowired
    private BuildingManagementService buildingManagementService;
    @Autowired
    private BuildingManagementWrapper buildingManagementWrapper;
    @Autowired
    private UserService userService;
    @Autowired
    private OfficeService officeService;
    @Autowired
    private ParkManagementService parkManagementService;
    @Autowired
    private EnterpriseInfoService enterpriseInfoService;

    @ApiLog(value="\u67e5\u8be2\u697c\u5b87\u4fe1\u606f\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u697c\u5b87\u4fe1\u606f\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('buildinginfo:buildingManagement:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<BuildingManagement>> list(BuildingManagementDTO buildingManagementDTO, Page<BuildingManagement> page) throws Exception {
        String officeId;
        String qyid;
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)buildingManagementDTO), BuildingManagementDTO.class);
        UserDTO userDTO = UserUtils.getCurrentUserDTO();
        String[] roleIds = userDTO.getRoleIds().split(",");
        if (Arrays.asList(roleIds).contains("6931d8e6e4974f898010bb22fbccaa14") && (qyid = this.buildingManagementService.findQyidByOfficeid(officeId = userDTO.getOfficeDTO().getId())) != null && !qyid.equals("")) {
            queryWrapper.eq((Object)"id", (Object)qyid);
        }
        if (StringUtils.isNotBlank((String)buildingManagementDTO.getReserve5())) {
            queryWrapper.eq((Object)"park_management", (Object)buildingManagementDTO.getReserve5());
        }
        IPage result = this.buildingManagementService.page((IPage)page, (Wrapper)queryWrapper);
        List records = result.getRecords();
        for (int i = 0; i < records.size(); ++i) {
            String parkManagementId = ((BuildingManagement)((Object)records.get(i))).getParkManagementId();
            ParkManagement byId = (ParkManagement)((Object)this.parkManagementService.getById((Serializable)((Object)parkManagementId)));
            String id = ((BuildingManagement)((Object)records.get(i))).getId();
            QueryWrapper queryWrapper1 = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper1.eq((Object)"des6", (Object)"1")).eq((Object)"des1", (Object)id)).eq((Object)"del_flag", (Object)"0");
            int count = this.enterpriseInfoService.count((Wrapper)queryWrapper1);
            ((BuildingManagement)((Object)records.get(i))).setParkName(byId.getParkName());
            ((BuildingManagement)((Object)records.get(i))).setReserve3(String.valueOf(count));
        }
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u67e5\u8be2\u697c\u5b87\u4fe1\u606f\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u697c\u5b87\u4fe1\u606f\u5217\u8868\u6570\u636e")
    @GetMapping(value={"list1"})
    public ResponseEntity<IPage<BuildingManagement>> list1(BuildingManagementDTO buildingManagementDTO, Page<BuildingManagement> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)buildingManagementDTO), BuildingManagementDTO.class);
        IPage result = this.buildingManagementService.page((IPage)page, (Wrapper)queryWrapper);
        List records = result.getRecords();
        for (int i = 0; i < records.size(); ++i) {
            String parkManagementId = ((BuildingManagement)((Object)records.get(i))).getParkManagementId();
            ParkManagement byId = (ParkManagement)((Object)this.parkManagementService.getById((Serializable)((Object)parkManagementId)));
            String id = ((BuildingManagement)((Object)records.get(i))).getId();
            QueryWrapper queryWrapper1 = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper1.eq((Object)"des6", (Object)"1")).eq((Object)"des1", (Object)id)).eq((Object)"del_flag", (Object)"0");
            int count = this.enterpriseInfoService.count((Wrapper)queryWrapper1);
            ((BuildingManagement)((Object)records.get(i))).setParkName(byId.getParkName());
            ((BuildingManagement)((Object)records.get(i))).setReserve3(String.valueOf(count));
        }
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u697c\u5b87\u4fe1\u606f\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u697c\u5b87\u4fe1\u606f\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('buildinginfo:buildingManagement:view','buildinginfo:buildingManagement:add','buildinginfo:buildingManagement:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<BuildingManagementDTO> queryById(String id) {
        return ResponseEntity.ok((Object)((Object)this.buildingManagementService.findById(id)));
    }

    @ApiLog(value="\u4fdd\u5b58\u697c\u5b87\u4fe1\u606f")
    @ApiOperation(value="\u4fdd\u5b58\u697c\u5b87\u4fe1\u606f")
    @PreAuthorize(value="hasAnyAuthority('buildinginfo:buildingManagement:add','buildinginfo:buildingManagement:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody BuildingManagementDTO buildingManagementDTO) {
        String officeid = UUID.randomUUID().toString().replace("-", "");
        String buildid = UUID.randomUUID().toString().replace("-", "");
        String oldLoginname = "";
        String oldBuildingManagementName = "";
        if (buildingManagementDTO.getId() != null && !buildingManagementDTO.getId().equals("")) {
            oldLoginname = ((BuildingManagement)((Object)this.buildingManagementService.getById((Serializable)((Object)buildingManagementDTO.getId())))).getReserve2();
            oldBuildingManagementName = ((BuildingManagement)((Object)this.buildingManagementService.getById((Serializable)((Object)buildingManagementDTO.getId())))).getBuildingName();
        }
        if (null == buildingManagementDTO.getId() || buildingManagementDTO.getId().isEmpty()) {
            buildingManagementDTO.setPlace("320900/320903/320903004");
            buildingManagementDTO.setPlaceSelectType3("320900");
            buildingManagementDTO.setPlaceSelectType4("320903");
            buildingManagementDTO.setPlaceSelectType5("320903004");
            Office office = new Office();
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"name", (Object)buildingManagementDTO.getBuildingName())).eq((Object)"type", (Object)"2")).eq((Object)"grade", (Object)"3")).eq((Object)"del_flag", (Object)"0");
            Office one = (Office)this.officeService.getOne((Wrapper)queryWrapper);
            String id = buildingManagementDTO.getParkManagement().getId();
            ParkManagement byId = (ParkManagement)((Object)this.parkManagementService.getById((Serializable)((Object)id)));
            String parkName = byId.getParkName();
            QueryWrapper queryWrapper1 = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper1.eq((Object)"name", (Object)parkName)).eq((Object)"type", (Object)"2")).eq((Object)"grade", (Object)"2")).eq((Object)"del_flag", (Object)"0");
            Office one1 = (Office)this.officeService.getOne((Wrapper)queryWrapper1);
            if (null != one) {
                return ResponseEntity.badRequest().body((Object)"\u5df2\u5b58\u5728\uff01");
            }
            UserDTO cuserDTO = UserUtils.getCurrentUserDTO();
            this.officeService.insertOffice(officeid, "2", "3", "1", buildingManagementDTO.getBuildingName(), one1.getId(), "0,1852255263109984258," + one1.getId() + ",", cuserDTO.getId());
            UserDTO userDTO = new UserDTO();
            userDTO.setLoginName(buildingManagementDTO.getReserve2());
            userDTO.setPassword(SecurityUtils.encryptPassword((String)buildingManagementDTO.getReserve2()));
            userDTO.setMobile(buildingManagementDTO.getReserve2());
            userDTO.setName(buildingManagementDTO.getReserve2());
            userDTO.setLoginFlag("1");
            OfficeDTO companyDTO = new OfficeDTO();
            companyDTO.setId("1852255263109984258");
            companyDTO.setType("1");
            userDTO.setCompanyDTO(companyDTO);
            OfficeDTO officeDTO = new OfficeDTO();
            officeDTO.setType("2");
            officeDTO.setGrade("3");
            QueryWrapper queryWrapper2 = new QueryWrapper();
            ((QueryWrapper)queryWrapper2.like((Object)"name", (Object)buildingManagementDTO.getBuildingName())).eq((Object)"del_flag", (Object)"0");
            List list = this.officeService.list((Wrapper)queryWrapper2);
            if (null == list || list.size() <= 0) {
                return ResponseEntity.badRequest().body((Object)"\u65e0\u8be5\u697c\u5b87\u4fe1\u606f\uff01");
            }
            officeDTO.setId(((Office)list.get(0)).getId());
            userDTO.setOfficeDTO(officeDTO);
            ArrayList roleDTOList = Lists.newArrayList();
            RoleDTO roleDTO = new RoleDTO();
            roleDTO.setId("6931d8e6e4974f898010bb22fbccaa14");
            roleDTOList.add(roleDTO);
            userDTO.setRoleDTOList((List)roleDTOList);
            this.userService.saveOrUpdate(userDTO);
            BuildingManagement p = this.buildingManagementWrapper.toEntity(buildingManagementDTO);
            p.setId(buildid);
            UserDTO userDTO2 = UserUtils.getCurrentUserDTO();
            p.setCreateBy(userDTO2.getId());
            p.setCreateDate(new Date());
            p.setUpdateBy(userDTO2.getId());
            p.setUpdateDate(new Date());
            p.setDelFlag(0);
            this.buildingManagementService.insertBuildingManagement(p);
            this.officeService.saveOfficeMiddleTable(officeid, buildid, "", "2");
        } else {
            String reserve2 = buildingManagementDTO.getReserve2();
            if (!oldLoginname.equals(reserve2)) {
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)queryWrapper.like((Object)"name", (Object)oldBuildingManagementName)).eq((Object)"del_flag", (Object)"0");
                Office one = (Office)this.officeService.getOne((Wrapper)queryWrapper);
                one.setName(buildingManagementDTO.getBuildingName());
                this.officeService.saveOrUpdate((TreeEntity)one);
                UserDTO olduserDTO = this.userService.getUserByLoginName(oldLoginname);
                olduserDTO.setLoginName(buildingManagementDTO.getReserve2());
                olduserDTO.setName(buildingManagementDTO.getReserve2());
                olduserDTO.setPassword(SecurityUtils.encryptPassword((String)buildingManagementDTO.getReserve2()));
                olduserDTO.setMobile(buildingManagementDTO.getReserve2());
                this.userService.saveOrUpdate(olduserDTO);
            }
            this.buildingManagementService.saveOrUpdate((Object)this.buildingManagementWrapper.toEntity(buildingManagementDTO));
        }
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u697c\u5b87\u4fe1\u606f\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u697c\u5b87\u4fe1\u606f")
    @ApiOperation(value="\u5220\u9664\u697c\u5b87\u4fe1\u606f")
    @PreAuthorize(value="hasAuthority('buildinginfo:buildingManagement:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.buildingManagementService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u697c\u5b87\u4fe1\u606f\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u697c\u5b87\u4fe1\u606f\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('buildinginfo:buildingManagement:export')")
    @GetMapping(value={"export"})
    public void exportFile(BuildingManagementDTO buildingManagementDTO, Page<BuildingManagementDTO> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)buildingManagementDTO), BuildingManagementDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"a.id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = this.buildingManagementService.findPage(page, queryWrapper).getRecords();
        EasyExcelUtils.newInstance((IService)this.buildingManagementService, (EntityWrapper)this.buildingManagementWrapper).exportExcel(result, options.getSheetName(), BuildingManagementDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('buildinginfo:buildingManagement:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.buildingManagementService, (EntityWrapper)this.buildingManagementWrapper).importExcel(file, BuildingManagementDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('buildinginfo:buildingManagement:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u697c\u5b87\u4fe1\u606f\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.buildingManagementService, (EntityWrapper)this.buildingManagementWrapper).exportExcel((List)list, "\u697c\u5b87\u4fe1\u606f\u6570\u636e", BuildingManagementDTO.class, fileName, null, response);
    }
}

