/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.buildinginfo.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.buildinginfo.domain.BuildingManagement;
import com.jeeplus.buildinginfo.mapper.BuildingManagementMapper;
import com.jeeplus.buildinginfo.service.dto.BuildingManagementDTO;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BuildingManagementService
extends ServiceImpl<BuildingManagementMapper, BuildingManagement> {
    public BuildingManagementDTO findById(String id) {
        return ((BuildingManagementMapper)this.baseMapper).findById(id);
    }

    public IPage<BuildingManagementDTO> findPage(Page<BuildingManagementDTO> page, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((BuildingManagementMapper)this.baseMapper).findList(page, queryWrapper);
    }

    public int insertBuildingManagement(BuildingManagement buildingManagement) {
        return ((BuildingManagementMapper)this.baseMapper).insertBuildingManagement(buildingManagement);
    }

    public HashMap<String, Object> getLYTaxRanking() {
        return ((BuildingManagementMapper)this.baseMapper).getLYTaxRanking();
    }

    public List<Map<String, Object>> getTaxRanking() {
        return ((BuildingManagementMapper)this.baseMapper).getTaxRanking();
    }

    public String getYearTaxRevenue() {
        return ((BuildingManagementMapper)this.baseMapper).getYearTaxRevenue();
    }

    public String getMonthTaxRevenue(String formattedDate) {
        return ((BuildingManagementMapper)this.baseMapper).getMonthTaxRevenue(formattedDate);
    }

    public List<Map<String, Object>> getParkTotl() {
        return ((BuildingManagementMapper)this.baseMapper).getParkTotl();
    }

    public List<Map<String, Object>> getParkIndustryTotal(String searchid) {
        return ((BuildingManagementMapper)this.baseMapper).getParkIndustryTotal(searchid);
    }

    public List<Map<String, Object>> getParkIndustry(String searchid) {
        return ((BuildingManagementMapper)this.baseMapper).getParkIndustry(searchid);
    }

    public List<Map<String, Object>> getParkIndustry2(String searchid) {
        return ((BuildingManagementMapper)this.baseMapper).getParkIndustry2(searchid);
    }

    public Map<String, Object> getQyfx(String searchid, String year) {
        return ((BuildingManagementMapper)this.baseMapper).getQyfx(searchid, year);
    }

    public Map<String, Object> getQyfx2(String searchid, String year) {
        return ((BuildingManagementMapper)this.baseMapper).getQyfx2(searchid, year);
    }

    public Map<String, Object> getQyfx3(String searchid, String year) {
        return ((BuildingManagementMapper)this.baseMapper).getQyfx3(searchid, year);
    }

    public List<Map<String, Object>> getNewEnterprise(String searchid) {
        return ((BuildingManagementMapper)this.baseMapper).getNewEnterprise(searchid);
    }

    public String getCountQY(String lyid) {
        return ((BuildingManagementMapper)this.baseMapper).getCountQY(lyid);
    }

    public String getCountMJ(String lyid) {
        return ((BuildingManagementMapper)this.baseMapper).getCountMJ(lyid);
    }

    public Map<String, Object> getCountAllMJ(String lyid) {
        return ((BuildingManagementMapper)this.baseMapper).getCountAllMJ(lyid);
    }

    public String getCountLYMJ(String lyid) {
        return ((BuildingManagementMapper)this.baseMapper).getCountLYMJ(lyid);
    }

    public List<Map<String, Object>> getQymj(String searchid) {
        return ((BuildingManagementMapper)this.baseMapper).getQymj(searchid);
    }

    public String getPerNum(String qyid) {
        return ((BuildingManagementMapper)this.baseMapper).getPerNum(qyid);
    }

    public HashMap<String, Object> getSaleStatistics(String qyid) {
        LocalDate localDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        DateTimeFormatter formatteryear = DateTimeFormatter.ofPattern("yyyy");
        String currentYear = localDate.format(formatter);
        LocalDate today = LocalDate.now();
        YearMonth lastMonth = YearMonth.from(today).minusMonths(1L);
        String lastYear = lastMonth.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        return ((BuildingManagementMapper)this.baseMapper).getSaleStatistics(qyid, lastYear + "", currentYear + "");
    }

    public String findQyidByOfficeid(String officeId) {
        return ((BuildingManagementMapper)this.baseMapper).findQyidByOfficeid(officeId);
    }
}

