/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.saleinventory.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.dp.SaleDTO;
import com.jeeplus.enterpriseinfo.service.EnterpriseInfoService;
import com.jeeplus.enterpriseinfo.service.dto.EnterpriseInfoDTO;
import com.jeeplus.saleinventory.domain.SaleInventory;
import com.jeeplus.saleinventory.mapper.SaleInventoryMapper;
import com.jeeplus.saleinventory.service.dto.SaleInventoryDTO;
import com.jeeplus.saleinventory.service.mapstruct.SaleInventoryWrapper;
import java.text.DecimalFormat;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SaleInventoryService
extends ServiceImpl<SaleInventoryMapper, SaleInventory> {
    @Autowired
    private EnterpriseInfoService enterpriseInfoService;
    @Autowired
    private SaleInventoryWrapper saleInventoryWrapper;

    public SaleInventoryDTO findById(String id) {
        return ((SaleInventoryMapper)this.baseMapper).findById(id);
    }

    public IPage<SaleInventoryDTO> findPage(Page<SaleInventoryDTO> page, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((SaleInventoryMapper)this.baseMapper).findList(page, queryWrapper);
    }

    public HashMap<String, Object> getSaleStatistics(String qyid) {
        int currentYear = Year.now().getValue();
        int lastYear = currentYear - 1;
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatistics(qyid, lastYear + "", currentYear + "");
    }

    public List<HashMap<String, Object>> getSaleStatisticsForYear(String lb) {
        int currentYear = Year.now().getValue();
        int lastYear = currentYear - 1;
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForYear(lastYear + "", currentYear + "", lb);
    }

    public List<HashMap<String, Object>> getSaleStatisticsForYearLyid(String lyid, String lb) {
        int currentYear = Year.now().getValue();
        int lastYear = currentYear - 1;
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForYearLyid(lastYear + "", currentYear + "", lyid, lb);
    }

    public List<HashMap<String, Object>> getSaleStatisticsForYearQy(String qyid, String lb) {
        int currentYear = Year.now().getValue();
        int lastYear = currentYear - 1;
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForYearQy(qyid, lastYear + "", currentYear + "", lb);
    }

    public SaleDTO getSaleStatisticsForHbyqid(String yqid) {
        YearMonth currentYearMonth = YearMonth.now();
        YearMonth lastYearMonth = currentYearMonth.minusYears(1L);
        YearMonth lastYearMonth2 = currentYearMonth.minusMonths(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String formattedYearMonth = currentYearMonth.format(formatter);
        String lastYearMonthS = lastYearMonth.format(formatter);
        String lastformattedYearMonth = lastYearMonth2.format(formatter);
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForHbyqid(yqid, lastYearMonthS, formattedYearMonth, lastformattedYearMonth);
    }

    public SaleDTO getSaleStatisticsForHbLyid(String lyid) {
        YearMonth currentYearMonth = YearMonth.now();
        YearMonth lastYearMonth = currentYearMonth.minusYears(1L);
        YearMonth lastYearMonth2 = currentYearMonth.minusMonths(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String formattedYearMonth = currentYearMonth.format(formatter);
        String lastYearMonthS = lastYearMonth.format(formatter);
        String lastformattedYearMonth = lastYearMonth2.format(formatter);
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForHbLyid(lyid, lastYearMonthS, formattedYearMonth, lastformattedYearMonth);
    }

    public SaleDTO getSaleStatisticsForHbQy(String qyid) {
        YearMonth currentYearMonth = YearMonth.now();
        YearMonth lastYearMonth = currentYearMonth.minusYears(1L);
        YearMonth lastYearMonth2 = currentYearMonth.minusMonths(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String formattedYearMonth = currentYearMonth.format(formatter);
        String lastYearMonthS = lastYearMonth.format(formatter);
        String lastformattedYearMonth = lastYearMonth2.format(formatter);
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForHbQy(qyid, lastYearMonthS, formattedYearMonth, lastformattedYearMonth);
    }

    public HashMap<String, Object> getNewSEMounth() {
        return ((SaleInventoryMapper)this.baseMapper).getNewSEMounth();
    }

    public SaleDTO getSaleStatisticsForHbyqid2(String yqid, String smonth, String emonth, String lastsmonth, String lastemonth) {
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForHbyqid2(yqid, smonth, emonth, lastsmonth, lastemonth);
    }

    public SaleDTO getSaleStatisticsForHbLyid2(String lyid, String smonth, String emonth, String lastsmonth, String lastemonth) {
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForHbLyid2(lyid, smonth, emonth, lastsmonth, lastemonth);
    }

    public SaleDTO getSaleStatisticsForHbQy2(String qyid, String smonth, String emonth, String lastsmonth, String lastemonth) {
        return ((SaleInventoryMapper)this.baseMapper).getSaleStatisticsForHbQy2(qyid, smonth, emonth, lastsmonth, lastemonth);
    }

    public List<HashMap<String, Object>> getNowYearSaleByLyid(String lyid, String smonth, String emonth) {
        return ((SaleInventoryMapper)this.baseMapper).getNowYearSaleByLyid(lyid, smonth, emonth);
    }

    public List<HashMap<String, Object>> getNowYearSaleByYqid(String yqid, String smonth, String emonth) {
        return ((SaleInventoryMapper)this.baseMapper).getNowYearSaleByYqid(yqid, smonth, emonth);
    }

    public String ce1() {
        List<HashMap<String, Object>> alist = ((SaleInventoryMapper)this.baseMapper).ce1();
        for (int i = 0; i < alist.size(); ++i) {
            String ssb;
            String ss324;
            double ss124d;
            String ss124;
            String ss224;
            String ss1242;
            String xs324;
            double xs124d;
            String xs124;
            String xs224;
            String xs1242;
            String ss23;
            String xs23;
            HashMap<String, Object> ap = alist.get(i);
            EnterpriseInfoDTO enterpriseInfoDTO = this.enterpriseInfoService.findByName(ap.get("name").toString());
            if (enterpriseInfoDTO == null || enterpriseInfoDTO.getId() == null || ap.get("xs23") == null) continue;
            if (ap.get("xs23") != null && !(xs23 = ap.get("xs23").toString()).equals("")) {
                double xs23d = Double.parseDouble(xs23);
                this.saveSale("1", xs23d, enterpriseInfoDTO, "2023-01", "2023-12");
            }
            if (ap.get("ss23") != null && !(ss23 = ap.get("ss23").toString()).equals("")) {
                double ss23d = Double.parseDouble(ss23);
                this.saveSale("2", ss23d, enterpriseInfoDTO, "2023-01", "2023-12");
            }
            if (ap.get("xs124") != null && !(xs1242 = ap.get("xs124").toString()).equals("")) {
                double xs124d2 = Double.parseDouble(xs1242);
                this.saveSale("1", xs124d2, enterpriseInfoDTO, "2024-01", "2024-03");
            }
            if (ap.get("xs224") != null && !(xs224 = ap.get("xs224").toString()).equals("")) {
                double xs224d = Double.parseDouble(xs224);
                if (ap.get("xs124") != null && !(xs124 = ap.get("xs124").toString()).equals("")) {
                    xs124d = Double.parseDouble(xs124);
                    xs224d += xs124d;
                }
                this.saveSale("1", xs224d, enterpriseInfoDTO, "2024-01", "2024-06");
            }
            if (ap.get("xs324") != null && !(xs324 = ap.get("xs324").toString()).equals("")) {
                String xs2242;
                double xs324d = Double.parseDouble(xs324);
                if (ap.get("xs124") != null && !(xs124 = ap.get("xs124").toString()).equals("")) {
                    xs124d = Double.parseDouble(xs124);
                    xs324d += xs124d;
                }
                if (ap.get("xs224") != null && !(xs2242 = ap.get("xs224").toString()).equals("")) {
                    double xs224d = Double.parseDouble(xs2242);
                    xs324d += xs224d;
                }
                this.saveSale("1", xs324d, enterpriseInfoDTO, "2024-01", "2024-09");
            }
            if (ap.get("ss124") != null && !(ss1242 = ap.get("ss124").toString()).equals("")) {
                double ss124d2 = Double.parseDouble(ss1242);
                this.saveSale("2", ss124d2, enterpriseInfoDTO, "2024-01", "2024-03");
            }
            if (ap.get("ss224") != null && !(ss224 = ap.get("ss224").toString()).equals("")) {
                double ss224d = Double.parseDouble(ss224);
                if (ap.get("ss124") != null && !(ss124 = ap.get("ss124").toString()).equals("")) {
                    ss124d = Double.parseDouble(ss124);
                    ss224d += ss124d;
                }
                this.saveSale("2", ss224d, enterpriseInfoDTO, "2024-01", "2024-06");
            }
            if (ap.get("ss324") != null && !(ss324 = ap.get("ss324").toString()).equals("")) {
                String ss2242;
                double ss324d = Double.parseDouble(ss324);
                if (ap.get("ss124") != null && !(ss124 = ap.get("ss124").toString()).equals("")) {
                    ss124d = Double.parseDouble(ss124);
                    ss324d += ss124d;
                }
                if (ap.get("ss224") != null && !(ss2242 = ap.get("ss224").toString()).equals("")) {
                    double ss224d = Double.parseDouble(ss2242);
                    ss324d += ss224d;
                }
                this.saveSale("2", ss324d, enterpriseInfoDTO, "2024-01", "2024-09");
            }
            if (ap.get("ssb") == null || (ssb = ap.get("ssb").toString()).equals("")) continue;
            double ssbd = Double.parseDouble(ssb);
            SaleInventoryDTO saleInventoryDTO = new SaleInventoryDTO();
            DecimalFormat df = new DecimalFormat("#.00");
            String formattedNumber = df.format(ssbd);
            double result = Double.parseDouble(formattedNumber);
            saleInventoryDTO.setAmount(String.valueOf(result));
            saleInventoryDTO.setQiId(enterpriseInfoDTO.getId());
            saleInventoryDTO.setLb("2");
            saleInventoryDTO.setDes1("2024-01");
            saleInventoryDTO.setDes2("2024-08");
            saleInventoryDTO.setDes3("1");
            this.saveOrUpdate((Object)this.saleInventoryWrapper.toEntity(saleInventoryDTO));
        }
        return "ok";
    }

    private void saveSale(String lb, double oned, EnterpriseInfoDTO enterpriseInfoDTO, String des1, String des2) {
        DecimalFormat df = new DecimalFormat("#.00");
        String formattedNumber = df.format(oned);
        double result = Double.parseDouble(formattedNumber);
        SaleInventoryDTO saleInventoryDTO = new SaleInventoryDTO();
        saleInventoryDTO.setAmount(String.valueOf(result));
        saleInventoryDTO.setQiId(enterpriseInfoDTO.getId());
        saleInventoryDTO.setLb(lb);
        saleInventoryDTO.setDes1(des1);
        saleInventoryDTO.setDes2(des2);
        saleInventoryDTO.setDes3("0");
        this.saveOrUpdate((Object)this.saleInventoryWrapper.toEntity(saleInventoryDTO));
    }
}

