/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.datav.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.datav.domain.DataComponent;
import com.jeeplus.datav.service.DataComponentService;
import com.jeeplus.datav.service.dto.DataComponentDTO;
import com.jeeplus.datav.service.mapstruct.DataComponentWrapper;
import java.io.Serializable;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datav/dataComponent"})
public class DataComponentController {
    @Autowired
    private DataComponentService dataComponentService;
    @Autowired
    private DataComponentWrapper dataComponentWrapper;

    @ApiLog(value="\u67e5\u8be2\u5927\u5c4f\u7ec4\u4ef6\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('datav:dataComponent:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<DataComponentDTO>> list(DataComponentDTO dataComponentDTO, Page<DataComponent> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)dataComponentDTO), DataComponentDTO.class);
        Page result = this.dataComponentWrapper.toDTO((Page)this.dataComponentService.page((IPage)page, (Wrapper)queryWrapper));
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u5927\u5c4f\u7ec4\u4ef6\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('datav:dataComponent:view','datav:dataComponent:add','datav:dataComponent:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<DataComponentDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.dataComponentWrapper.toDTO(this.dataComponentService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u5927\u5c4f\u7ec4\u4ef6")
    @PreAuthorize(value="hasAnyAuthority('datav:dataComponent:add','datav:dataComponent:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody DataComponentDTO dataComponentDTO) {
        this.dataComponentService.saveOrUpdate(this.dataComponentWrapper.toEntity((Object)dataComponentDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5927\u5c4f\u7ec4\u4ef6\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u5927\u5c4f\u7ec4\u4ef6")
    @PreAuthorize(value="hasAuthority('datav:dataComponent:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.dataComponentService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5927\u5c4f\u7ec4\u4ef6\u6210\u529f");
    }
}

