/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.file.controller;

import cn.hutool.core.util.StrUtil;
import com.jeeplus.file.config.FileProperties;
import com.jeeplus.file.repository.AccessoryRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/file"})
public class FileController {
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private AccessoryRepository accessoryRepository;
    private String FILE_SERVER = "/file";

    @GetMapping(value={"download"})
    public void download(String uploadPath, String name, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String url = this.accessoryRepository.getURL(uploadPath, name, request, response);
        if (StrUtil.isNotEmpty((CharSequence)url)) {
            try {
                response.sendRedirect(url);
            }
            catch (IOException e) {
                throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
        }
    }

    @RequestMapping(value={"upload"})
    public ResponseEntity upload(HttpServletRequest request, MultipartFile file) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        String uploadPath = request.getParameter("uploadPath") + "/" + year + "/" + month + "/";
        if (!file.isEmpty()) {
            String name = file.getOriginalFilename();
            if (this.fileProperties.isAvailable(name)) {
                this.accessoryRepository.save(file, uploadPath, name);
                return ResponseEntity.ok((Object)(this.FILE_SERVER + "/download?uploadPath=" + uploadPath + "&name=" + name));
            }
            return ResponseEntity.badRequest().body((Object)"\u8bf7\u52ff\u4e0a\u4f20\u975e\u6cd5\u6587\u4ef6!");
        }
        return ResponseEntity.badRequest().body((Object)"\u6587\u4ef6\u4e0d\u5b58\u5728!");
    }

    @GetMapping(value={"downloadFile"}, produces={"application/octet-stream"})
    public ResponseEntity<StreamingResponseBody> downloadFile(String uploadPath, String name) throws Exception {
        File file = this.accessoryRepository.get(uploadPath, name);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-disposition", new String[]{"attachment; filename=" + name})).body(outputStream -> {
            try (FileInputStream inputStream = new FileInputStream(file);){
                StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @RequestMapping(value={"uploadFile"})
    public ResponseEntity uploadFile(HttpServletRequest request, MultipartFile file) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        String uploadPath = request.getParameter("uploadPath") + "/" + year + "/" + month + "/";
        if (!file.isEmpty()) {
            String name = file.getOriginalFilename();
            if (this.fileProperties.isAvailable(name)) {
                this.accessoryRepository.save(file, uploadPath, name);
                return ResponseEntity.ok((Object)(this.FILE_SERVER + "/downloadFile?uploadPath=" + uploadPath + "&name=" + name));
            }
            return ResponseEntity.badRequest().body((Object)"\u8bf7\u52ff\u4e0a\u4f20\u975e\u6cd5\u6587\u4ef6!");
        }
        return ResponseEntity.badRequest().body((Object)"\u6587\u4ef6\u4e0d\u5b58\u5728!");
    }
}

