/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.qyuser.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.qyuser.service.QyUserService;
import com.jeeplus.qyuser.service.dto.QyUserDTO;
import com.jeeplus.qyuser.service.mapstruct.QyUserWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4f01\u4e1a\u4eba\u5458"})
@RestController
@RequestMapping(value={"/qyuser/qyUser"})
public class QyUserController {
    @Autowired
    private QyUserService qyUserService;
    @Autowired
    private QyUserWrapper qyUserWrapper;

    @ApiLog(value="\u67e5\u8be2\u4f01\u4e1a\u4eba\u5458\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u4f01\u4e1a\u4eba\u5458\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('qyuser:qyUser:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<QyUserDTO>> list(QyUserDTO qyUserDTO, Page<QyUserDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)qyUserDTO), QyUserDTO.class);
        IPage<QyUserDTO> result = this.qyUserService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u4eba\u5458\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u4eba\u5458\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('qyuser:qyUser:view','qyuser:qyUser:add','qyuser:qyUser:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<QyUserDTO> queryById(String id) {
        return ResponseEntity.ok((Object)((Object)this.qyUserService.findById(id)));
    }

    @ApiLog(value="\u4fdd\u5b58\u4f01\u4e1a\u4eba\u5458")
    @ApiOperation(value="\u4fdd\u5b58\u4f01\u4e1a\u4eba\u5458")
    @PreAuthorize(value="hasAnyAuthority('qyuser:qyUser:add','qyuser:qyUser:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody QyUserDTO qyUserDTO) {
        this.qyUserService.saveOrUpdate((Object)this.qyUserWrapper.toEntity(qyUserDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u4f01\u4e1a\u4eba\u5458\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u4f01\u4e1a\u4eba\u5458")
    @ApiOperation(value="\u5220\u9664\u4f01\u4e1a\u4eba\u5458")
    @PreAuthorize(value="hasAuthority('qyuser:qyUser:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.qyUserService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u4f01\u4e1a\u4eba\u5458\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u4f01\u4e1a\u4eba\u5458\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('qyuser:qyUser:export')")
    @GetMapping(value={"export"})
    public void exportFile(QyUserDTO qyUserDTO, Page<QyUserDTO> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)qyUserDTO), QyUserDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"a.id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = this.qyUserService.findPage(page, queryWrapper).getRecords();
        EasyExcelUtils.newInstance((IService)this.qyUserService, (EntityWrapper)this.qyUserWrapper).exportExcel(result, options.getSheetName(), QyUserDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('qyuser:qyUser:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.qyUserService, (EntityWrapper)this.qyUserWrapper).importExcel(file, QyUserDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('qyuser:qyUser:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u4f01\u4e1a\u4eba\u5458\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.qyUserService, (EntityWrapper)this.qyUserWrapper).exportExcel((List)list, "\u4f01\u4e1a\u4eba\u5458\u6570\u636e", QyUserDTO.class, fileName, null, response);
    }
}

