/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.datav.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.database.datalink.domain.DataSource;
import com.jeeplus.database.datalink.jdbc.DBPool;
import com.jeeplus.database.datalink.service.DataSourceService;
import com.jeeplus.datav.domain.DataScreen;
import com.jeeplus.datav.model.DataSetRequest;
import com.jeeplus.datav.service.DataScreenService;
import com.jeeplus.datav.service.dto.DataScreenDTO;
import com.jeeplus.datav.service.mapstruct.DataScreenWrapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datav/dataScreen"})
public class DataScreenController {
    @Autowired
    private DataScreenService dataScreenService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DataScreenWrapper dataScreenWrapper;

    @PreAuthorize(value="hasAuthority('datav:dataScreen:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<DataScreenDTO>> list(DataScreen dataScreen, Page<DataScreen> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)dataScreen), DataScreen.class);
        Page result = (Page)this.dataScreenService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)this.dataScreenWrapper.toDTO(result));
    }

    @PreAuthorize(value="hasAnyAuthority('datav:dataScreen:view','datav:dataScreen:add','datav:dataScreen:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<DataScreenDTO> queryById(String id) {
        DataScreenDTO dataScreenDTO = this.dataScreenWrapper.toDTO((DataScreen)((Object)this.dataScreenService.getById((Serializable)((Object)id))));
        return ResponseEntity.ok((Object)((Object)dataScreenDTO));
    }

    @GetMapping(value={"copy"})
    public ResponseEntity<String> copy(String id) {
        DataScreen dataScreen = (DataScreen)((Object)this.dataScreenService.getById((Serializable)((Object)id)));
        dataScreen.setId(null);
        dataScreen.setName(dataScreen.getName() + "-copy");
        this.dataScreenService.save((Object)dataScreen);
        return ResponseEntity.ok((Object)"\u590d\u5236\u5927\u5c4f\u6210\u529f!");
    }

    @PreAuthorize(value="hasAnyAuthority('datav:dataScreen:add','datav:dataScreen:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@RequestBody @Valid DataScreenDTO dataScreenDTO) {
        this.dataScreenService.saveOrUpdate((Object)this.dataScreenWrapper.toEntity(dataScreenDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5927\u5c4f\u8bbe\u8ba1\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('datav:dataScreen:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.dataScreenService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5927\u5c4f\u8bbe\u8ba1\u6210\u529f");
    }

    @PostMapping(value={"/sqlQuery"})
    public ResponseEntity exec(@RequestBody DataSetRequest dataSetRequest) {
        DataSource dataSource = this.dataSourceService.getById(dataSetRequest.getDb());
        if (dataSource == null) {
            return ResponseEntity.badRequest().body((Object)"\u6570\u636e\u5e93\u94fe\u63a5\u4e0d\u5b58\u5728!");
        }
        String sql = dataSetRequest.getSql();
        JdbcTemplate jdbcTemplate = DBPool.getInstance().getJdbcTemplateByEnName(dataSource.getEnName());
        if (sql.contains("delete") || sql.contains("update")) {
            return ResponseEntity.badRequest().body((Object)"\u53ea\u5141\u8bb8\u67e5\u8be2\u64cd\u4f5c!");
        }
        List list = jdbcTemplate.queryForList(sql);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("data", list);
        return ResponseEntity.ok(result);
    }
}

