/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.enterprisewater.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.enterpriseinfo.service.EnterpriseInfoService;
import com.jeeplus.enterprisewater.domain.EnterpriseWater;
import com.jeeplus.enterprisewater.service.EnterpriseWaterService;
import com.jeeplus.enterprisewater.service.dto.EnterpriseWaterDTO;
import com.jeeplus.enterprisewater.service.mapstruct.EnterpriseWaterWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4f01\u4e1a\u6c34\u8d39"})
@RestController
@RequestMapping(value={"/enterprisewater/enterpriseWater"})
public class EnterpriseWaterController {
    @Autowired
    private EnterpriseWaterService enterpriseWaterService;
    @Autowired
    private EnterpriseWaterWrapper enterpriseWaterWrapper;
    @Autowired
    private EnterpriseInfoService enterpriseInfoService;

    @ApiLog(value="\u67e5\u8be2\u4f01\u4e1a\u6c34\u8d39\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u4f01\u4e1a\u6c34\u8d39\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('enterprisewater:enterpriseWater:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<EnterpriseWaterDTO>> list(EnterpriseWaterDTO enterpriseWaterDTO, Page<EnterpriseWaterDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)enterpriseWaterDTO), EnterpriseWaterDTO.class);
        IPage<EnterpriseWaterDTO> result = this.enterpriseWaterService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u6c34\u8d39\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u6c34\u8d39\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('enterprisewater:enterpriseWater:view','enterprisewater:enterpriseWater:add','enterprisewater:enterpriseWater:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<EnterpriseWaterDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.enterpriseWaterWrapper.toDTO(this.enterpriseWaterService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u4f01\u4e1a\u6c34\u8d39")
    @ApiOperation(value="\u4fdd\u5b58\u4f01\u4e1a\u6c34\u8d39")
    @PreAuthorize(value="hasAnyAuthority('enterprisewater:enterpriseWater:add','enterprisewater:enterpriseWater:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody EnterpriseWaterDTO enterpriseWaterDTO) {
        this.enterpriseWaterService.saveOrUpdate(this.enterpriseWaterWrapper.toEntity((Object)enterpriseWaterDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u4f01\u4e1a\u6c34\u8d39\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u4f01\u4e1a\u6c34\u8d39")
    @ApiOperation(value="\u5220\u9664\u4f01\u4e1a\u6c34\u8d39")
    @PreAuthorize(value="hasAuthority('enterprisewater:enterpriseWater:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.enterpriseWaterService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u4f01\u4e1a\u6c34\u8d39\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u4f01\u4e1a\u6c34\u8d39\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('enterprisewater:enterpriseWater:export')")
    @GetMapping(value={"export"})
    public void exportFile(EnterpriseWaterDTO enterpriseWaterDTO, Page<EnterpriseWater> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)enterpriseWaterDTO), EnterpriseWaterDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = ((Page)this.enterpriseWaterService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        EasyExcelUtils.newInstance((IService)this.enterpriseWaterService, (EntityWrapper)this.enterpriseWaterWrapper).exportExcel(result, options.getSheetName(), EnterpriseWaterDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('enterprisewater:enterpriseWater:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.enterpriseWaterService, (EntityWrapper)this.enterpriseWaterWrapper).importExcel(file, EnterpriseWaterDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('enterprisewater:enterpriseWater:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u4f01\u4e1a\u6c34\u8d39\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.enterpriseWaterService, (EntityWrapper)this.enterpriseWaterWrapper).exportExcel((List)list, "\u4f01\u4e1a\u6c34\u8d39\u6570\u636e", EnterpriseWaterDTO.class, fileName, null, response);
    }
}

