/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.mapVisualization.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.mapVisualization.domain.MapVisualization;
import com.jeeplus.mapVisualization.mapper.MapVisualizationMapper;
import com.jeeplus.mapVisualization.service.PinYinUtil;
import com.jeeplus.mapVisualization.service.dto.MapVisualizationDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MapVisualizationService
extends ServiceImpl<MapVisualizationMapper, MapVisualization> {
    public ArrayList<HashMap<String, Object>> getBuildingList() {
        return ((MapVisualizationMapper)this.baseMapper).getBuildingList();
    }

    public List<Map<String, Object>> getCompanyList(HashMap<String, Object> condition_map) {
        ArrayList<HashMap<String, Object>> cl_list = ((MapVisualizationMapper)this.baseMapper).getCompanyList(condition_map);
        cl_list.stream().forEach(map -> {
            String companyName = (String)map.get("companyName");
            if (!companyName.isEmpty()) {
                char firstChar = companyName.charAt(0);
                String pinyinInitial = PinYinUtil.getPinYinHeadChar(firstChar);
                map.put("firstChar", String.valueOf(firstChar));
                map.put("pinyinInitial", pinyinInitial);
            }
        });
        Map groupedAndSorted = cl_list.stream().collect(Collectors.groupingBy(map -> (String)map.get("pinyinInitial"), Collectors.toList()));
        List sortedEntries = groupedAndSorted.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        List<Map<String, Object>> sortedList = sortedEntries.stream().map(entry -> {
            HashMap<String, Object> singleEntryMap = new HashMap<String, Object>();
            singleEntryMap.put("name", entry.getKey());
            singleEntryMap.put("companyList", entry.getValue());
            return singleEntryMap;
        }).collect(Collectors.toList());
        return sortedList;
    }

    public Integer getCompanyNum(String buildingId) {
        return ((MapVisualizationMapper)this.baseMapper).getCompanyNum(buildingId);
    }

    public MapVisualizationDTO findById(String id) {
        return ((MapVisualizationMapper)this.baseMapper).findById(id);
    }

    public IPage<MapVisualizationDTO> findPage(Page<MapVisualizationDTO> page, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((MapVisualizationMapper)this.baseMapper).findList(page, queryWrapper);
    }
}

