/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.aop.logging;

import com.jeeplus.aop.logging.service.AsyncLogService;
import com.jeeplus.aop.logging.utils.LogUtils;
import com.jeeplus.sys.domain.Log;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class LoggingAspect {
    private final Environment env;
    private final AsyncLogService asyncLogService;

    public LoggingAspect(Environment env, AsyncLogService asyncLogService) {
        this.env = env;
        this.asyncLogService = asyncLogService;
    }

    public HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
    }

    @Pointcut(value="@annotation(com.jeeplus.aop.logging.annotation.ApiLog)")
    public void applicationPackagePointcut() {
    }

    @AfterThrowing(pointcut="applicationPackagePointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) throws Throwable {
        HttpServletRequest request = this.getHttpServletRequest();
        Log log = LogUtils.getLog(request, joinPoint, 0L, null, e);
        this.asyncLogService.saveLog(log);
    }

    @Around(value="applicationPackagePointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = joinPoint.proceed();
        long time = System.currentTimeMillis() - startTime;
        HttpServletRequest request = this.getHttpServletRequest();
        Log log = LogUtils.getLog(request, (JoinPoint)joinPoint, time, result != null ? result.toString() : "", null);
        this.asyncLogService.saveLog(log);
        return result;
    }
}

