/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.excel;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.util.ListUtils;
import com.baomidou.mybatisplus.extension.service.IService;
import com.jeeplus.common.beanvalidator.BeanValidators;
import com.jeeplus.core.mapstruct.EntityWrapper;
import java.util.Collection;
import java.util.List;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelListener<T>
implements ReadListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelListener.class);
    private String message;
    private static final int BATCH_COUNT = 100;
    private List<T> cachedDataList = ListUtils.newArrayListWithExpectedSize((int)100);
    private IService service;
    private EntityWrapper wrapper;

    public ExcelListener(IService service, EntityWrapper wrapper) {
        this.service = service;
        this.wrapper = wrapper;
    }

    public void invoke(T data, AnalysisContext context) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)data.toString());
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 100) {
            this.saveData();
            this.cachedDataList = ListUtils.newArrayListWithExpectedSize((int)100);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.saveData();
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }

    public void saveData() {
        log.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u5e93\uff01", (Object)this.cachedDataList.size());
        Validator validator = (Validator)SpringUtil.getBean(Validator.class);
        StringBuilder failureMsg = new StringBuilder();
        this.cachedDataList.forEach(cachedData -> {
            try {
                BeanValidators.validateWithException((Validator)validator, (Object)cachedData, (Class[])new Class[0]);
            }
            catch (ConstraintViolationException ex) {
                List messageList = BeanValidators.extractPropertyAndMessageAsList((ConstraintViolationException)ex, (String)": ");
                for (String message : messageList) {
                    failureMsg.append(message + "; ");
                }
            }
        });
        if (StrUtil.isNotEmpty((CharSequence)failureMsg.toString())) {
            this.message = failureMsg.toString();
            log.info(this.message);
            return;
        }
        this.service.saveBatch((Collection)this.wrapper.toEntity(this.cachedDataList));
        this.message = "\u5bfc\u5165\u6570\u636e\u5e93\u6210\u529f\uff01";
    }

    public String getMessage() {
        return this.message;
    }

    public List<T> getCachedDataList() {
        return this.cachedDataList;
    }

    public IService getService() {
        return this.service;
    }

    public EntityWrapper getWrapper() {
        return this.wrapper;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCachedDataList(List<T> cachedDataList) {
        this.cachedDataList = cachedDataList;
    }

    public void setService(IService service) {
        this.service = service;
    }

    public void setWrapper(EntityWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelListener)) {
            return false;
        }
        ExcelListener other = (ExcelListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<T> this$cachedDataList = this.getCachedDataList();
        List<T> other$cachedDataList = other.getCachedDataList();
        if (this$cachedDataList == null ? other$cachedDataList != null : !((Object)this$cachedDataList).equals(other$cachedDataList)) {
            return false;
        }
        IService this$service = this.getService();
        IService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        EntityWrapper this$wrapper = this.getWrapper();
        EntityWrapper other$wrapper = other.getWrapper();
        return !(this$wrapper == null ? other$wrapper != null : !this$wrapper.equals(other$wrapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<T> $cachedDataList = this.getCachedDataList();
        result = result * 59 + ($cachedDataList == null ? 43 : ((Object)$cachedDataList).hashCode());
        IService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        EntityWrapper $wrapper = this.getWrapper();
        result = result * 59 + ($wrapper == null ? 43 : $wrapper.hashCode());
        return result;
    }

    public String toString() {
        return "ExcelListener(message=" + this.getMessage() + ", cachedDataList=" + this.getCachedDataList() + ", service=" + this.getService() + ", wrapper=" + this.getWrapper() + ")";
    }
}

