/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.sys.domain.DictType;
import com.jeeplus.sys.domain.DictValue;
import com.jeeplus.sys.service.DictTypeService;
import com.jeeplus.sys.service.DictValueService;
import com.jeeplus.sys.service.mapstruct.DictValueWrapper;
import com.jeeplus.sys.utils.DictUtils;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/dict"})
public class DictController {
    @Autowired
    private DictTypeService dictTypeService;
    @Autowired
    private DictValueService dictValueService;
    @Autowired
    private DictValueWrapper dictValueWrapper;

    @ApiLog(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u83b7\u53d6\u5b57\u5178\u5217\u8868")
    @PreAuthorize(value="hasAuthority('sys:dict:list')")
    @GetMapping(value={"getDictValue"})
    public ResponseEntity getDictValue(String dictTypeId) {
        List<Object> list = Lists.newArrayList();
        if (StrUtil.isNotBlank((CharSequence)dictTypeId)) {
            list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.dictValueService.lambdaQuery().eq(DictValue::getDictTypeId, (Object)dictTypeId)).orderByAsc(DictValue::getSort)).list().stream().map(arg_0 -> ((DictValueWrapper)this.dictValueWrapper).toDTO(arg_0)).collect(Collectors.toList());
        }
        return ResponseEntity.ok((Object)list);
    }

    @ApiLog(value="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u5217\u8868")
    @PreAuthorize(value="hasAuthority('sys:dict:list')")
    @GetMapping(value={"type/list"})
    public ResponseEntity<IPage<DictType>> data(DictType dictType, Page<DictType> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)dictType, DictType.class);
        IPage result = this.dictTypeService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b")
    @PreAuthorize(value="hasAnyAuthority('sys:dict:view','sys:dict:add','sys:dict:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(String id) {
        DictType dictType = (DictType)this.dictTypeService.getById((Serializable)((Object)id));
        return ResponseEntity.ok((Object)dictType);
    }

    @ApiLog(value="\u6839\u636eid\u83b7\u53d6\u5b57\u5178\u503c")
    @PreAuthorize(value="hasAnyAuthority('sys:dict:view','sys:dict:add','sys:dict:edit')")
    @GetMapping(value={"queryDictValue"})
    public ResponseEntity queryDictValue(String dictValueId) {
        DictValue dictValue = (DictValue)this.dictValueService.getById((Serializable)((Object)dictValueId));
        return ResponseEntity.ok((Object)dictValue);
    }

    @DemoMode
    @ApiLog(value="\u4fdd\u5b58\u5b57\u5178\u7c7b\u578b")
    @PreAuthorize(value="hasAnyAuthority('sys:dict:add','sys:dict:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@RequestBody @Valid DictType dictType) {
        this.dictTypeService.saveOrUpdate(dictType);
        return ResponseEntity.ok((Object)("\u4fdd\u5b58\u5b57\u5178\u7c7b\u578b'" + dictType.getRemarks() + "'\u6210\u529f\uff01"));
    }

    @DemoMode
    @ApiLog(value="\u4fdd\u5b58\u5b57\u5178\u503c")
    @PreAuthorize(value="hasAnyAuthority('sys:dict:add','sys:dict:edit')")
    @PostMapping(value={"saveDictValue"})
    public ResponseEntity saveDictValue(@Valid @RequestBody DictValue dictValue) {
        this.dictTypeService.saveDictValue(dictValue);
        return ResponseEntity.ok((Object)("\u4fdd\u5b58\u952e\u503c'" + dictValue.getLabel() + "'\u6210\u529f\uff01"));
    }

    @DemoMode
    @ApiLog(value="\u5220\u9664\u5b57\u5178\u503c")
    @PreAuthorize(value="hasAuthority('sys:dict:edit')")
    @DeleteMapping(value={"deleteDictValue"})
    public ResponseEntity deleteDictValue(String ids) {
        this.dictTypeService.batchDeleteDictValue(ids.split(","));
        return ResponseEntity.ok((Object)"\u5220\u9664\u952e\u503c\u6210\u529f\uff01");
    }

    @DemoMode
    @ApiLog(value="\u6279\u91cf\u5220\u9664\u5b57\u5178")
    @PreAuthorize(value="hasAuthority('sys:dict:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            this.dictTypeService.delete(id);
        }
        return ResponseEntity.ok((Object)"\u5220\u9664\u5b57\u5178\u6210\u529f\uff01");
    }

    @ApiLog(value="\u83b7\u53d6\u5b57\u5178\u96c6")
    @GetMapping(value={"getDictMap"})
    public ResponseEntity getDictMap() {
        return ResponseEntity.ok(DictUtils.getDictMap());
    }
}

