/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller.app;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.sys.controller.UserController;
import com.jeeplus.sys.domain.Office;
import com.jeeplus.sys.domain.User;
import com.jeeplus.sys.service.OfficeService;
import com.jeeplus.sys.service.UserService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/sys/user"})
public class AppUserController
extends UserController {
    @Autowired
    OfficeService officeService;
    @Autowired
    UserService userService;

    @GetMapping(value={"treeData"})
    public ResponseEntity treeData() {
        List list = this.officeService.list();
        List<Map> rootTree = this.getRootTree(list);
        return ResponseEntity.ok(rootTree);
    }

    private List<Map> getRootTree(List<Office> list) {
        ArrayList offices = Lists.newArrayList();
        List rootTrees = this.officeService.treeData();
        for (Office root : rootTrees) {
            offices.add(this.getChildOfTree(root, list));
        }
        return offices;
    }

    private Map getChildOfTree(Office officeItem, List<Office> officeList) {
        HashMap<String, Object> oMap = new HashMap<String, Object>();
        oMap.put("id", "o_" + officeItem.getId());
        oMap.put("type", "office");
        oMap.put("label", officeItem.getName());
        ArrayList children = Lists.newArrayList();
        oMap.put("children", children);
        List list = ((LambdaQueryChainWrapper)this.userService.lambdaQuery().eq(User::getOfficeId, (Object)officeItem.getId())).list();
        for (int i = 0; i < list.size(); ++i) {
            User e = (User)list.get(i);
            HashMap map = Maps.newHashMap();
            map.put("id", e.getId());
            map.put("type", "user");
            map.put("label", e.getName());
            children.add(map);
        }
        for (Office child : officeList) {
            if (!child.getParentId().equals(officeItem.getId())) continue;
            children.add(this.getChildOfTree(child, officeList));
        }
        return oMap;
    }
}

