/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.service;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.core.service.TreeService;
import com.jeeplus.sys.constant.enums.OfficeTypeEnum;
import com.jeeplus.sys.domain.Office;
import com.jeeplus.sys.mapper.OfficeMapper;
import com.jeeplus.sys.service.dto.OfficeDTO;
import com.jeeplus.sys.service.mapstruct.OfficeWrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OfficeService
extends TreeService<OfficeMapper, Office> {
    @Autowired
    private OfficeWrapper officeWrapper;

    public List<OfficeDTO> getRootTree(List<OfficeDTO> list, String extId, String type, String showAll) {
        ArrayList offices = Lists.newArrayList();
        List rootTrees = this.officeWrapper.toDTO(super.getChildren(new Office(OfficeDTO.getRootId())));
        for (OfficeDTO root : rootTrees) {
            if (!this.isUseAble(extId, type, root, showAll)) continue;
            List<OfficeDTO> officeList = this.formatListToTree(root, list, extId, type, showAll);
            offices.addAll(officeList);
        }
        return offices;
    }

    public List<OfficeDTO> formatListToTree(OfficeDTO root, List<OfficeDTO> allList, String extId, String type, String showAll) {
        String rootId = root.getId();
        if (OfficeTypeEnum.OFFICE.getValue().equals(type) && root.getType().equals(OfficeTypeEnum.COMPANY.getValue())) {
            root.setDisabled(true);
        } else {
            root.setDisabled(false);
        }
        ArrayList trees = Lists.newArrayList();
        HashMap treeMap = Maps.newHashMap();
        for (OfficeDTO entity : allList) {
            List offices = (List)treeMap.get(((OfficeDTO)entity.getParent()).getId());
            if (offices == null) {
                offices = Lists.newLinkedList();
            }
            if (!this.isUseAble(extId, type, root, showAll)) continue;
            if (OfficeTypeEnum.COMPANY.getValue().equals(type) && entity.getType().equals(type) || OfficeTypeEnum.OFFICE.getValue().equals(type) || StrUtil.isBlank((CharSequence)type)) {
                if (OfficeTypeEnum.OFFICE.getValue().equals(type) && entity.getType().equals(OfficeTypeEnum.COMPANY.getValue())) {
                    entity.setDisabled(true);
                } else {
                    entity.setDisabled(false);
                }
                offices.add(entity);
            }
            treeMap.put(((OfficeDTO)entity.getParent()).getId(), offices);
        }
        List children = (List)treeMap.get(rootId);
        if (children != null) {
            for (OfficeDTO parent : children) {
                this.formatFillChildren(parent, treeMap);
                trees.add(parent);
            }
        }
        root.setChildren(trees);
        return Lists.newArrayList((Object[])new OfficeDTO[]{root});
    }

    private void formatFillChildren(OfficeDTO parent, Map<String, List<OfficeDTO>> treeMap) {
        List<OfficeDTO> children = treeMap.get(parent.getId());
        parent.setChildren(children);
        if (children != null && !children.isEmpty()) {
            for (OfficeDTO child : children) {
                this.formatFillChildren(child, treeMap);
            }
        }
    }

    private boolean isUseAble(String extId, String type, OfficeDTO dto, String showAll) {
        return !(!StringUtils.isBlank((String)extId) && (extId == null || extId.equals(dto.getId()) || dto.getParentIds().indexOf("," + extId + ",") != -1) || type != null && (type == null || type.equals(OfficeTypeEnum.COMPANY.getValue()) && !type.equals(dto.getType())) || !"1".equals(showAll) && !"1".equals(dto.getUseable()));
    }

    public int insertOffice(String id, String type, String grade, String useable, String name, String parent_id, String parent_ids, String create_by) {
        return ((OfficeMapper)this.baseMapper).insertOffice(id, type, grade, useable, name, parent_id, parent_ids, create_by, new Date());
    }

    public int saveOfficeMiddleTable(String office_id, String build_id, String qy_id, String stype) {
        return ((OfficeMapper)this.baseMapper).saveOfficeMiddleTable(office_id, build_id, qy_id, stype);
    }

    public String getOfficeIdFromMiddleTable(String other_id, String stype) {
        if (stype.equals("3")) {
            return ((OfficeMapper)this.baseMapper).getOfficeIdFromMiddleTableByqy(other_id, stype);
        }
        return ((OfficeMapper)this.baseMapper).getOfficeIdFromMiddleTable(other_id, stype);
    }

    public HashMap<String, Object> getOtherIdByOffceid(String officeid) {
        return ((OfficeMapper)this.baseMapper).getOtherIdByOffceid(officeid);
    }
}

