/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.servlet;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.jeeplus.config.properties.JeePlusProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.util.UriUtils;

@WebServlet(urlPatterns={"/userfiles/*"})
public class UserfilesDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void fileOutputStream(HttpServletRequest req, HttpServletResponse resp) {
        String filepath = req.getRequestURI();
        int index = filepath.indexOf("/userdir/");
        if (index >= 0) {
            filepath = filepath.substring(index + "/userdir/".length());
        }
        filepath = UriUtils.decode((String)filepath, (String)"UTF-8");
        JeePlusProperties jeePlusProperites = (JeePlusProperties)SpringUtil.getBean(JeePlusProperties.class);
        File file = new File(jeePlusProperites.getUserfilesBaseDir() + "/userdir/" + filepath);
        try {
            this.downRangeFile(file, resp, req);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.fileOutputStream(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.fileOutputStream(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downRangeFile(File downloadFile, HttpServletResponse response, HttpServletRequest request) throws Exception {
        String contentRange;
        String extName = "";
        if (!downloadFile.exists()) {
            response.sendError(404);
            return;
        }
        long fileLength = downloadFile.length();
        long pastLength = 0L;
        int rangeSwitch = 0;
        long toLength = 0L;
        long contentLength = 0L;
        String rangeBytes = "";
        RandomAccessFile raf = null;
        ServletOutputStream os = null;
        OutputStream out = null;
        int bsize = 1024;
        byte[] b = new byte[bsize];
        String range = request.getHeader("Range");
        int responseStatus = 206;
        if (range != null && range.trim().length() > 0 && !"null".equals(range)) {
            responseStatus = 206;
            rangeBytes = range.replaceAll("bytes=", "");
            if (rangeBytes.endsWith("-")) {
                rangeSwitch = 1;
                rangeBytes = rangeBytes.substring(0, rangeBytes.indexOf(45));
                pastLength = Long.parseLong(rangeBytes.trim());
                contentLength = fileLength - pastLength;
            } else {
                rangeSwitch = 2;
                String temp0 = rangeBytes.substring(0, rangeBytes.indexOf(45));
                String temp2 = rangeBytes.substring(rangeBytes.indexOf(45) + 1, rangeBytes.length());
                pastLength = Long.parseLong(temp0.trim());
                toLength = Long.parseLong(temp2);
                contentLength = toLength - pastLength + 1L;
            }
        } else {
            contentLength = fileLength;
        }
        response.reset();
        response.setHeader("Accept-Ranges", "bytes");
        if (rangeSwitch != 0) {
            response.setStatus(responseStatus);
            switch (rangeSwitch) {
                case 1: {
                    contentRange = new StringBuffer("bytes ").append(new Long(pastLength).toString()).append("-").append(new Long(fileLength - 1L).toString()).append("/").append(new Long(fileLength).toString()).toString();
                    response.setHeader("Content-Range", contentRange);
                    break;
                }
                case 2: {
                    contentRange = range.replace("=", " ") + "/" + new Long(fileLength).toString();
                    response.setHeader("Content-Range", contentRange);
                    break;
                }
            }
        } else {
            contentRange = new StringBuffer("bytes ").append("0-").append(fileLength - 1L).append("/").append(fileLength).toString();
            response.setHeader("Content-Range", contentRange);
        }
        try {
            String finalFileName = null;
            String userAgent = request.getHeader("USER-AGENT");
            finalFileName = StrUtil.contains((CharSequence)userAgent, (CharSequence)"MSIE") || StrUtil.contains((CharSequence)userAgent, (CharSequence)"Trident") || StrUtil.contains((CharSequence)userAgent, (CharSequence)"Edge") ? URLEncoder.encode(downloadFile.getName(), "UTF8") : (StrUtil.contains((CharSequence)userAgent, (CharSequence)"Mozilla") ? new String(downloadFile.getName().getBytes("GBK"), "iso8859-1") : URLEncoder.encode(downloadFile.getName(), "UTF8"));
            response.setHeader("Content-Disposition", "attachment;filename=" + finalFileName + "");
            response.setHeader("Content-Length", String.valueOf(contentLength));
            os = response.getOutputStream();
            out = new BufferedOutputStream((OutputStream)os);
            raf = new RandomAccessFile(downloadFile, "r");
            try {
                long outLength = 0L;
                switch (rangeSwitch) {
                    case 0: 
                    case 1: {
                        raf.seek(pastLength);
                        int n = 0;
                        while ((n = raf.read(b)) != -1) {
                            out.write(b, 0, n);
                            outLength += (long)n;
                        }
                        break;
                    }
                    case 2: {
                        raf.seek(pastLength);
                        int n = 0;
                        long readLength = 0L;
                        while (readLength <= contentLength - (long)bsize) {
                            n = raf.read(b);
                            readLength += (long)n;
                            out.write(b, 0, n);
                            outLength += (long)n;
                        }
                        if (readLength > contentLength) break;
                        n = raf.read(b, 0, (int)(contentLength - readLength));
                        out.write(b, 0, n);
                        outLength += (long)n;
                        break;
                    }
                }
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

