/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.enterpriseinfo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.buildinginfo.service.BuildingManagementService;
import com.jeeplus.core.domain.BaseEntity;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.enterpriseinfo.domain.EnterpriseInfo;
import com.jeeplus.enterpriseinfo.service.EnterpriseInfoService;
import com.jeeplus.enterpriseinfo.service.dto.EnterpriseInfoDTO;
import com.jeeplus.enterpriseinfo.service.mapstruct.EnterpriseInfoWrapper;
import com.jeeplus.security.util.SecurityUtils;
import com.jeeplus.sys.domain.DictValue;
import com.jeeplus.sys.domain.Office;
import com.jeeplus.sys.service.DictValueService;
import com.jeeplus.sys.service.OfficeService;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.OfficeDTO;
import com.jeeplus.sys.service.dto.RoleDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.service.mapstruct.DictValueWrapper;
import com.jeeplus.sys.utils.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/enterpriseinfo/enterpriseInfo"})
public class EnterpriseInfoController {
    @Autowired
    private EnterpriseInfoService enterpriseInfoService;
    @Autowired
    private EnterpriseInfoWrapper enterpriseInfoWrapper;
    @Autowired
    private DictValueService dictValueService;
    @Autowired
    private DictValueWrapper dictValueWrapper;
    @Autowired
    private UserService userService;
    @Autowired
    private OfficeService officeService;
    @Autowired
    private BuildingManagementService buildingManagementService;

    @ApiLog(value="\u67e5\u8be2\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('enterpriseinfo:enterpriseInfo:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<EnterpriseInfoDTO>> list(EnterpriseInfoDTO enterpriseInfoDTO, Page<EnterpriseInfoDTO> page) throws Exception {
        String lyid;
        String officeid;
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)enterpriseInfoDTO), EnterpriseInfoDTO.class);
        UserDTO userDTO = UserUtils.getCurrentUserDTO();
        String[] roleIds = userDTO.getRoleIds().split(",");
        if (Arrays.asList(roleIds).contains("38a14f1f42ed424eab4cb5d489596b0d")) {
            officeid = userDTO.getOfficeDTO().getId();
            String qyid = this.enterpriseInfoService.findQyidByOfficeid(officeid);
            if (qyid != null && !qyid.equals("")) {
                queryWrapper.eq((Object)"a.id", (Object)qyid);
            }
        } else if (Arrays.asList(roleIds).contains("6931d8e6e4974f898010bb22fbccaa14") && (lyid = this.enterpriseInfoService.findLyidByOfficeid(officeid = userDTO.getOfficeDTO().getId())) != null && !lyid.equals("")) {
            queryWrapper.eq((Object)"des1", (Object)lyid);
        }
        List person_type_list = ((LambdaQueryChainWrapper)this.dictValueService.lambdaQuery().eq(DictValue::getDictTypeId, (Object)"1852233185762918402")).list().stream().map(arg_0 -> ((DictValueWrapper)this.dictValueWrapper).toDTO(arg_0)).collect(Collectors.toList());
        IPage<EnterpriseInfoDTO> result = this.enterpriseInfoService.findPage(page, queryWrapper, enterpriseInfoDTO.getIndustry());
        for (int i = 0; i < result.getRecords().size(); ++i) {
            if (!StringUtils.isNotBlank((CharSequence)((EnterpriseInfoDTO)((Object)result.getRecords().get(i))).getIndustry())) continue;
            List<String> pt_array = Arrays.asList(((EnterpriseInfoDTO)((Object)result.getRecords().get(i))).getIndustry().split(","));
            String pt_names = person_type_list.stream().filter(dictValueDTO -> pt_array.contains(dictValueDTO.getValue())).map(dictValueDTO -> dictValueDTO.getLabel()).collect(Collectors.joining(","));
            if (!StringUtils.isNotBlank((CharSequence)pt_names)) continue;
            ((EnterpriseInfoDTO)((Object)result.getRecords().get(i))).setIndustryName(pt_names);
        }
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('enterpriseinfo:enterpriseInfo:view','enterpriseinfo:enterpriseInfo:add','enterpriseinfo:enterpriseInfo:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<EnterpriseInfoDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.enterpriseInfoWrapper.toDTO(this.enterpriseInfoService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @ApiOperation(value="\u4fdd\u5b58\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @PreAuthorize(value="hasAnyAuthority('enterpriseinfo:enterpriseInfo:add','enterpriseinfo:enterpriseInfo:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody EnterpriseInfoDTO enterpriseInfoDTO) {
        if (enterpriseInfoDTO.getOfficeArea() == null || enterpriseInfoDTO.getDes3().equals("")) {
            enterpriseInfoDTO.setOfficeArea("0");
        }
        String officeid = UUID.randomUUID().toString().replace("-", "");
        String enterpriseid = UUID.randomUUID().toString().replace("-", "");
        String oldLoginname = "";
        if (enterpriseInfoDTO.getId() != null && !enterpriseInfoDTO.getId().equals("")) {
            oldLoginname = ((EnterpriseInfo)((Object)this.enterpriseInfoService.getById((Serializable)((Object)enterpriseInfoDTO.getId())))).getPhone();
        }
        if (enterpriseInfoDTO.getId() == null || enterpriseInfoDTO.getId().equals("")) {
            enterpriseInfoDTO.setId(enterpriseid);
            if (enterpriseInfoDTO.getEntryTime() != null) {
                enterpriseInfoDTO.setDes6("1");
            }
            if (enterpriseInfoDTO.getDes5() != null && !enterpriseInfoDTO.getDes5().equals("")) {
                enterpriseInfoDTO.setDes6("2");
            }
            this.enterpriseInfoService.saveOrUpdate(this.enterpriseInfoWrapper.toEntity((Object)enterpriseInfoDTO));
            String lyofficeid = this.officeService.getOfficeIdFromMiddleTable(enterpriseInfoDTO.getDes1(), "2");
            Office office = (Office)this.officeService.getById((Serializable)((Object)lyofficeid));
            UserDTO cuserDTO = UserUtils.getCurrentUserDTO();
            this.officeService.insertOffice(officeid, "2", "4", "1", enterpriseInfoDTO.getName(), lyofficeid, office.getParentIds() + lyofficeid + ",", cuserDTO.getId());
            this.officeService.saveOfficeMiddleTable(officeid, "", enterpriseid, "3");
            UserDTO userDTO = new UserDTO();
            userDTO.setLoginName(enterpriseInfoDTO.getPhone());
            userDTO.setPassword(SecurityUtils.encryptPassword((String)enterpriseInfoDTO.getPhone()));
            userDTO.setName(enterpriseInfoDTO.getName());
            userDTO.setMobile(enterpriseInfoDTO.getPhone());
            OfficeDTO of = new OfficeDTO();
            of.setId("1852255263109984258");
            userDTO.setCompanyDTO(of);
            OfficeDTO of2 = new OfficeDTO();
            of2.setId(officeid);
            userDTO.setOfficeDTO(of2);
            userDTO.setNo("001");
            RoleDTO ro = new RoleDTO();
            ro.setId("38a14f1f42ed424eab4cb5d489596b0d");
            ArrayList<RoleDTO> ros = new ArrayList<RoleDTO>();
            ros.add(ro);
            userDTO.setRoleDTOList(ros);
            userDTO.setLoginFlag("1");
            this.userService.saveOrUpdate(userDTO);
        } else {
            if (enterpriseInfoDTO.getEntryTime() != null) {
                enterpriseInfoDTO.setDes6("1");
            }
            if (enterpriseInfoDTO.getDes5() != null && !enterpriseInfoDTO.getDes5().equals("")) {
                enterpriseInfoDTO.setDes6("2");
            }
            this.enterpriseInfoService.saveOrUpdate(this.enterpriseInfoWrapper.toEntity((Object)enterpriseInfoDTO));
            UserDTO olduserDTO = this.userService.getUserByLoginName(oldLoginname);
            if (olduserDTO != null) {
                olduserDTO.setLoginName(enterpriseInfoDTO.getPhone());
                olduserDTO.setPassword(SecurityUtils.encryptPassword((String)enterpriseInfoDTO.getPhone()));
                olduserDTO.setMobile(enterpriseInfoDTO.getPhone());
                this.userService.saveOrUpdate(olduserDTO);
            }
        }
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @ApiOperation(value="\u5220\u9664\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @PreAuthorize(value="hasAuthority('enterpriseinfo:enterpriseInfo:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.enterpriseInfoService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('enterpriseinfo:enterpriseInfo:export')")
    @GetMapping(value={"export"})
    public void exportFile(EnterpriseInfoDTO enterpriseInfoDTO, Page<EnterpriseInfoDTO> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String lyid;
        String officeid;
        UserDTO userDTO;
        String[] roleIds;
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)enterpriseInfoDTO), EnterpriseInfoDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        if (Arrays.asList(roleIds = (userDTO = UserUtils.getCurrentUserDTO()).getRoleIds().split(",")).contains("38a14f1f42ed424eab4cb5d489596b0d")) {
            officeid = userDTO.getOfficeDTO().getId();
            String qyid = this.enterpriseInfoService.findQyidByOfficeid(officeid);
            if (qyid != null && !qyid.equals("")) {
                queryWrapper.eq((Object)"id", (Object)qyid);
            }
        } else if (Arrays.asList(roleIds).contains("6931d8e6e4974f898010bb22fbccaa14") && (lyid = this.enterpriseInfoService.findLyidByOfficeid(officeid = userDTO.getOfficeDTO().getId())) != null && !lyid.equals("")) {
            queryWrapper.eq((Object)"des1", (Object)lyid);
        }
        List result = this.enterpriseInfoService.findPage(page, queryWrapper, enterpriseInfoDTO.getIndustry()).getRecords();
        EasyExcelUtils.newInstance((IService)this.enterpriseInfoService, (EntityWrapper)this.enterpriseInfoWrapper).exportExcel(result, options.getSheetName(), EnterpriseInfoDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('enterpriseinfo:enterpriseInfo:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.enterpriseInfoService, (EntityWrapper)this.enterpriseInfoWrapper).importExcel(file, EnterpriseInfoDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('enterpriseinfo:enterpriseInfo:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.enterpriseInfoService, (EntityWrapper)this.enterpriseInfoWrapper).exportExcel((List)list, "\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6570\u636e", EnterpriseInfoDTO.class, fileName, null, response);
    }

    @ApiLog(value="\u5ba1\u6838")
    @ApiOperation(value="\u5ba1\u6838")
    @PreAuthorize(value="hasAuthority('enterpriseinfo:enterpriseInfo:ko')")
    @PostMapping(value={"ko"})
    public ResponseEntity<String> keepOnRecord(String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(BaseEntity::getId, (Object)id)).set(EnterpriseInfo::getDes12, (Object)1);
            this.enterpriseInfoService.update(null, (Wrapper)lambdaUpdateWrapper);
        }
        return ResponseEntity.ok((Object)"\u5ba1\u6838\u6210\u529f");
    }
}

