/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.domain.TreeEntity;
import com.jeeplus.sys.domain.Office;
import com.jeeplus.sys.service.OfficeService;
import com.jeeplus.sys.service.dto.OfficeDTO;
import com.jeeplus.sys.service.mapstruct.OfficeWrapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/office"})
public class OfficeController {
    @Autowired
    private OfficeService officeService;
    @Autowired
    private OfficeWrapper officeWrapper;

    @ApiLog(value="\u67e5\u8be2\u90e8\u95e8")
    @PreAuthorize(value="hasAnyAuthority('sys:office:view','sys:office:add','sys:office:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(@RequestParam String id) {
        OfficeDTO officeDTO = this.officeWrapper.toDTO((Office)this.officeService.getById((Serializable)((Object)id)));
        return ResponseEntity.ok((Object)officeDTO);
    }

    @DemoMode
    @ApiLog(value="\u4fdd\u5b58\u90e8\u95e8")
    @PreAuthorize(value="hasAnyAuthority('sys:office:add','sys:office:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody OfficeDTO officeDTO) {
        this.officeService.saveOrUpdate(this.officeWrapper.toEntity(officeDTO));
        return ResponseEntity.ok((Object)("\u4fdd\u5b58\u673a\u6784'" + officeDTO.getName() + "'\u6210\u529f"));
    }

    @DemoMode
    @ApiLog(value="\u5220\u9664\u90e8\u95e8")
    @PreAuthorize(value="hasAuthority('sys:office:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String ids) {
        Object[] idArray = ids.split(",");
        this.officeService.removeWithChildrenByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiLog(value="\u83b7\u53d6\u90e8\u95e8\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity treeData(@RequestParam(required=false) String extId, @RequestParam(required=false) String type, @RequestParam(required=false, defaultValue="0") String showAll) {
        List list = this.officeWrapper.toDTO(((LambdaQueryChainWrapper)this.officeService.lambdaQuery().orderByAsc(TreeEntity::getSort)).list());
        List<OfficeDTO> rootTree = this.officeService.getRootTree(list, extId, type, showAll);
        return ResponseEntity.ok(rootTree);
    }

    @ApiLog(value="\u83b7\u53d6\u56ed\u533a\u6570\u636e")
    @GetMapping(value={"treeData2"})
    public ResponseEntity treeData2(@RequestParam(required=false) String extId, @RequestParam(required=false) String type, @RequestParam(required=false, defaultValue="0") String showAll) {
        List list = this.officeWrapper.toDTO(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.officeService.lambdaQuery().like(TreeEntity::getParentIds, (Object)"1852255263109984258")).orderByAsc(TreeEntity::getSort)).list());
        extId = "1504779078102695938";
        List<OfficeDTO> rootTree = this.officeService.getRootTree(list, extId, type, showAll);
        return ResponseEntity.ok(rootTree);
    }

    @ApiLog(value="\u83b7\u53d6\u56ed\u533a\u6570\u636e")
    @GetMapping(value={"getOtherIdByOffceid"})
    public ResponseEntity<HashMap<String, Object>> getOtherIdByOffceid(String officeid) {
        return ResponseEntity.ok(this.officeService.getOtherIdByOffceid(officeid));
    }
}

