/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.service;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.jeeplus.sys.domain.DictType;
import com.jeeplus.sys.domain.DictValue;
import com.jeeplus.sys.mapper.DictTypeMapper;
import com.jeeplus.sys.service.DictValueService;
import com.jeeplus.sys.service.dto.DictTypeDTO;
import com.jeeplus.sys.service.dto.DictValueDTO;
import com.jeeplus.sys.service.mapstruct.DictTypeWrapper;
import com.jeeplus.sys.service.mapstruct.DictValueWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DictTypeService
extends ServiceImpl<DictTypeMapper, DictType> {
    @Autowired
    private DictValueService dictValueService;
    @Autowired
    private DictTypeWrapper dictTypeWrapper;
    @Autowired
    private DictValueWrapper dictValueWrapper;

    @Transactional(readOnly=true)
    public DictTypeDTO get(String id) {
        DictTypeDTO dictTypeDTO = (DictTypeDTO)this.dictTypeWrapper.toDTO(super.getById((Serializable)((Object)id)));
        dictTypeDTO.setDictValueDTOList(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.dictValueService.lambdaQuery().eq(DictValue::getDictTypeId, (Object)id)).orderByAsc(DictValue::getSort)).list().stream().map(arg_0 -> ((DictValueWrapper)this.dictValueWrapper).toDTO(arg_0)).collect(Collectors.toList()));
        return dictTypeDTO;
    }

    @CacheEvict(value={"sys:cache:dictMap"}, allEntries=true)
    public boolean saveOrUpdate(DictType dictType) {
        return super.saveOrUpdate((Object)dictType);
    }

    @CacheEvict(value={"sys:cache:dictMap"}, allEntries=true)
    public void saveDictValue(DictValue dictValue) {
        this.dictValueService.saveOrUpdate(dictValue);
    }

    @CacheEvict(value={"sys:cache:dictMap"}, allEntries=true)
    public void batchDeleteDictValue(String[] ids) {
        this.dictValueService.removeByIds(Lists.newArrayList((Object[])ids));
    }

    @CacheEvict(value={"sys:cache:dictMap"}, allEntries=true)
    public void delete(String id) {
        super.removeById((Serializable)((Object)id));
        ((LambdaUpdateChainWrapper)this.dictValueService.lambdaUpdate().eq(DictValue::getDictTypeId, (Object)id)).remove();
    }

    @Cacheable(value={"sys:cache:dictMap"})
    public List<DictTypeDTO> getDict() {
        List list = this.dictTypeWrapper.toDTO(super.list());
        list.forEach(dictTypeDTO -> {
            List<DictValueDTO> dictValueDTOs = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.dictValueService.lambdaQuery().eq(DictValue::getDictTypeId, (Object)dictTypeDTO.getId())).orderByAsc(DictValue::getSort)).list().stream().map(arg_0 -> ((DictValueWrapper)this.dictValueWrapper).toDTO(arg_0)).collect(Collectors.toList());
            dictTypeDTO.setDictValueDTOList(dictValueDTOs);
        });
        return list;
    }
}

