/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.file.repository;

import cn.hutool.core.util.StrUtil;
import com.jeeplus.file.repository.AccessoryRepository;
import com.jeeplus.file.utils.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@ConditionalOnProperty(name={"config.accessory.type"}, havingValue="local")
public class LocalRepository
implements AccessoryRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${config.accessory.baseDir}")
    private String accessoryBaseDir;
    @Value(value="${config.accessory.local.location}")
    private String location;

    @Override
    public File get(String path, String fileName) throws FileNotFoundException {
        File fileDir;
        this.logger.debug("\u5f00\u59cb\u4ece\u672c\u5730\u5b58\u50a8\u83b7\u53d6\u6587\u4ef6: {}{}{}", new Object[]{this.location + File.separator + this.accessoryBaseDir + File.separator + path, File.separator, fileName});
        long begin = System.currentTimeMillis();
        File rootDir = new File(this.location + File.separator + this.accessoryBaseDir);
        if (path == null) {
            path = "";
        }
        if (!(fileDir = new File(rootDir, path)).exists() || !fileDir.isDirectory()) {
            throw new FileNotFoundException("\u6307\u5b9a\u7684\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        File srcFile = new File(fileDir, fileName);
        if (!srcFile.exists() || !srcFile.isFile()) {
            throw new FileNotFoundException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.logger.debug("\u5b8c\u6210\u4ece\u672c\u5730\u5b58\u50a8\u83b7\u53d6\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        return srcFile;
    }

    @Override
    public String getURL(String path, String fileName, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException {
        File fileDir;
        this.logger.debug("\u5f00\u59cb\u4ece\u672c\u5730\u5b58\u50a8\u83b7\u53d6\u6587\u4ef6: {}{}{}", new Object[]{this.location + File.separator + this.accessoryBaseDir + File.separator + path, File.separator, fileName});
        long begin = System.currentTimeMillis();
        File rootDir = new File(this.location + File.separator + this.accessoryBaseDir);
        if (path == null) {
            path = "";
        }
        if (!(fileDir = new File(rootDir, path)).exists() || !fileDir.isDirectory()) {
            throw new FileNotFoundException("\u6307\u5b9a\u7684\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        File srcFile = new File(fileDir, fileName);
        if (!srcFile.exists() || !srcFile.isFile()) {
            throw new FileNotFoundException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.downRangeFile(srcFile, request, response);
        this.logger.debug("\u5b8c\u6210\u4ece\u672c\u5730\u5b58\u50a8\u83b7\u53d6\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downRangeFile(File downloadFile, HttpServletRequest request, HttpServletResponse response) {
        String contentRange;
        if (!downloadFile.exists()) {
            try {
                response.sendError(404);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
            return;
        }
        long fileLength = downloadFile.length();
        long pastLength = 0L;
        int rangeSwitch = 0;
        long toLength = 0L;
        long contentLength = 0L;
        String rangeBytes = "";
        RandomAccessFile raf = null;
        ServletOutputStream os = null;
        OutputStream out = null;
        int bsize = 1024;
        byte[] b = new byte[bsize];
        String range = request.getHeader("Range");
        int responseStatus = 206;
        if (range != null && range.trim().length() > 0 && !"null".equals(range)) {
            responseStatus = 206;
            rangeBytes = range.replaceAll("bytes=", "");
            if (rangeBytes.endsWith("-")) {
                rangeSwitch = 1;
                rangeBytes = rangeBytes.substring(0, rangeBytes.indexOf(45));
                pastLength = Long.parseLong(rangeBytes.trim());
                contentLength = fileLength - pastLength;
            } else {
                rangeSwitch = 2;
                String temp0 = rangeBytes.substring(0, rangeBytes.indexOf(45));
                String temp2 = rangeBytes.substring(rangeBytes.indexOf(45) + 1, rangeBytes.length());
                pastLength = Long.parseLong(temp0.trim());
                toLength = Long.parseLong(temp2);
                contentLength = toLength - pastLength + 1L;
            }
        } else {
            contentLength = fileLength;
        }
        response.reset();
        response.setHeader("Accept-Ranges", "bytes");
        if (rangeSwitch != 0) {
            response.setStatus(responseStatus);
            switch (rangeSwitch) {
                case 1: {
                    contentRange = new StringBuffer("bytes ").append(new Long(pastLength).toString()).append("-").append(new Long(fileLength - 1L).toString()).append("/").append(new Long(fileLength).toString()).toString();
                    response.setHeader("Content-Range", contentRange);
                    break;
                }
                case 2: {
                    contentRange = range.replace("=", " ") + "/" + new Long(fileLength).toString();
                    response.setHeader("Content-Range", contentRange);
                    break;
                }
            }
        } else {
            contentRange = new StringBuffer("bytes ").append("0-").append(fileLength - 1L).append("/").append(fileLength).toString();
            response.setHeader("Content-Range", contentRange);
        }
        try {
            String finalFileName = null;
            String userAgent = request.getHeader("USER-AGENT");
            finalFileName = StrUtil.contains((CharSequence)userAgent, (CharSequence)"MSIE") || StrUtil.contains((CharSequence)userAgent, (CharSequence)"Trident") || StrUtil.contains((CharSequence)userAgent, (CharSequence)"Edge") ? URLEncoder.encode(downloadFile.getName(), "UTF8") : (StrUtil.contains((CharSequence)userAgent, (CharSequence)"Mozilla") ? new String(downloadFile.getName().getBytes("GBK"), "iso8859-1") : URLEncoder.encode(downloadFile.getName(), "UTF8"));
            response.setHeader("Content-Disposition", "attachment;filename=" + finalFileName + "");
            response.setHeader("Content-Length", String.valueOf(contentLength));
            os = response.getOutputStream();
            out = new BufferedOutputStream((OutputStream)os);
            raf = new RandomAccessFile(downloadFile, "r");
            try {
                long outLength = 0L;
                switch (rangeSwitch) {
                    case 0: 
                    case 1: {
                        raf.seek(pastLength);
                        int n = 0;
                        while ((n = raf.read(b)) != -1) {
                            out.write(b, 0, n);
                            outLength += (long)n;
                        }
                        break;
                    }
                    case 2: {
                        raf.seek(pastLength);
                        int n = 0;
                        long readLength = 0L;
                        while (readLength <= contentLength - (long)bsize) {
                            n = raf.read(b);
                            readLength += (long)n;
                            out.write(b, 0, n);
                            outLength += (long)n;
                        }
                        if (readLength > contentLength) break;
                        n = raf.read(b, 0, (int)(contentLength - readLength));
                        out.write(b, 0, n);
                        outLength += (long)n;
                        break;
                    }
                }
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File save(File file, String path, String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411\u672c\u5730\u5b58\u50a8\u4fdd\u5b58\u6587\u4ef6: {}{}{}", new Object[]{this.location + File.separator + this.accessoryBaseDir + File.separator + path, File.separator, fileName});
        long begin = System.currentTimeMillis();
        try {
            File destFile = this.createDestFile(path, fileName);
            this.checkFile(destFile);
            FileUtils.copyFile((File)file, (File)destFile);
            File file2 = destFile;
            return file2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.logger.debug("\u5b8c\u6210\u4ece\u672c\u5730\u5b58\u50a8\u83b7\u53d6\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File save(MultipartFile file, String path, String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411\u672c\u5730\u5b58\u50a8\u4fdd\u5b58\u6587\u4ef6: {}{}{}", new Object[]{this.location + File.separator + this.accessoryBaseDir + File.separator + path, File.separator, fileName});
        long begin = System.currentTimeMillis();
        try {
            File destFile = this.createDestFile(path, fileName);
            this.checkFile(destFile);
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)destFile);
            File file2 = destFile;
            return file2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.logger.debug("\u5b8c\u6210\u4ece\u672c\u5730\u5b58\u50a8\u83b7\u53d6\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File save(InputStream is, String path, @NotNull String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411\u672c\u5730\u5b58\u50a8\u4fdd\u5b58\u6587\u4ef6: {}{}{}", new Object[]{this.location + File.separator + this.accessoryBaseDir + File.separator + path, File.separator, fileName});
        long begin = System.currentTimeMillis();
        try {
            File destFile = this.createDestFile(path, fileName);
            this.checkFile(destFile);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)destFile);
            File file = destFile;
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.logger.debug("\u5b8c\u6210\u4ece\u672c\u5730\u5b58\u50a8\u83b7\u53d6\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        }
        return null;
    }

    @Override
    public String writeByUrl(MultipartFile file, String url) {
        return null;
    }

    private File createDestFile(String path, String fileName) {
        File rootDir = new File(this.location + File.separator + this.accessoryBaseDir);
        if (path == null) {
            path = "";
        }
        File destDir = new File(rootDir, path);
        FileUtils.createDirectory(destDir.getAbsolutePath());
        return new File(destDir, fileName);
    }

    private void checkFile(File file) {
        if (file.exists()) {
            this.logger.warn("\u6307\u5b9a\u7684\u6587\u4ef6\u5df2\u5b58\u5728, \u672c\u6b21\u64cd\u4f5c\u5c06\u4f1a\u8986\u76d6: {}", (Object)file.getAbsolutePath());
            if (file.isDirectory()) {
                this.logger.error("\u6307\u5b9a\u7684\u6587\u4ef6\u662f\u6587\u4ef6\u5939, \u4fdd\u5b58\u6587\u4ef6\u64cd\u4f5c\u65e0\u6cd5\u8fdb\u884c.");
                throw new RuntimeException("\u6307\u5b9a\u7684\u6587\u4ef6\u662f\u6587\u4ef6\u5939, \u4fdd\u5b58\u6587\u4ef6\u64cd\u4f5c\u65e0\u6cd5\u8fdb\u884c.");
            }
        }
    }
}

