/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.ureport.service;

import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.file.FileReportProvider;
import com.jeeplus.ureport.cache.ErasableMemoryCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportService.class);
    private final ErasableMemoryCache erasableMemoryCache;
    private final FileReportProvider fileReportProvider;

    public ReportService(ErasableMemoryCache erasableMemoryCache, FileReportProvider fileReportProvider) {
        this.erasableMemoryCache = erasableMemoryCache;
        this.fileReportProvider = fileReportProvider;
    }

    public List<ReportFile> getReportFiles() {
        log.debug("ReportService.getReportFiles");
        return this.fileReportProvider.getReportFiles();
    }

    public void deleteReport(String file) {
        log.debug("ReportService.deleteReport, file: {}", (Object)file);
        if (file.startsWith(this.fileReportProvider.getPrefix())) {
            this.fileReportProvider.deleteReport(file);
        } else {
            log.error("ReportService.deleteReport, error when deleteById: {}", (Object)file);
        }
        if (this.erasableMemoryCache != null) {
            this.erasableMemoryCache.clearCache();
        }
    }
}

