/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.manytomany.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.test.manytomany.domain.Course;
import com.jeeplus.test.manytomany.service.CourseService;
import com.jeeplus.test.manytomany.service.dto.CourseDTO;
import com.jeeplus.test.manytomany.service.mapstruct.CourseWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8bfe\u7a0b"})
@RestController
@RequestMapping(value={"/test/manytomany/course"})
public class CourseController {
    @Autowired
    private CourseService courseService;
    @Autowired
    private CourseWrapper courseWrapper;

    @ApiLog(value="\u67e5\u8be2\u8bfe\u7a0b\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u8bfe\u7a0b\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('test:manytomany:course:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<Course>> list(CourseDTO courseDTO, Page<Course> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)courseDTO), CourseDTO.class);
        IPage result = this.courseService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u8bfe\u7a0b\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u8bfe\u7a0b\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:manytomany:course:view','test:manytomany:course:add','test:manytomany:course:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<CourseDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.courseWrapper.toDTO(this.courseService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u8bfe\u7a0b")
    @ApiOperation(value="\u4fdd\u5b58\u8bfe\u7a0b")
    @PreAuthorize(value="hasAnyAuthority('test:manytomany:course:add','test:manytomany:course:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody CourseDTO courseDTO) {
        this.courseService.saveOrUpdate(this.courseWrapper.toEntity((Object)courseDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u8bfe\u7a0b\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u8bfe\u7a0b")
    @ApiOperation(value="\u5220\u9664\u8bfe\u7a0b")
    @PreAuthorize(value="hasAuthority('test:manytomany:course:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.courseService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u8bfe\u7a0b\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u8bfe\u7a0b\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:manytomany:course:export')")
    @GetMapping(value={"export"})
    public void exportFile(CourseDTO courseDTO, Page<Course> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)courseDTO), CourseDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = ((Page)this.courseService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        EasyExcelUtils.newInstance((IService)this.courseService, (EntityWrapper)this.courseWrapper).exportExcel(result, options.getSheetName(), CourseDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('test:manytomany:course:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.courseService, (EntityWrapper)this.courseWrapper).importExcel(file, CourseDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('test:manytomany:course:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u8bfe\u7a0b\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.courseService, (EntityWrapper)this.courseWrapper).exportExcel((List)list, "\u8bfe\u7a0b\u6570\u636e", CourseDTO.class, fileName, null, response);
    }
}

