/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.excel.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.jeeplus.core.excel.annotation.ExcelDictProperty;
import com.jeeplus.sys.utils.DictUtils;

public class ExcelDictDTOConverter
implements Converter<String> {
    public String convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String dictType = contentProperty.getField().getAnnotation(ExcelDictProperty.class).value();
        String val = cellData.getStringValue();
        return DictUtils.getDictValue(val, dictType, "-");
    }

    public WriteCellData<?> convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String dictType = contentProperty.getField().getAnnotation(ExcelDictProperty.class).value();
        WriteCellData objectWriteCellData = new WriteCellData(DictUtils.getDictLabel(value, dictType, "-"));
        return objectWriteCellData;
    }
}

