/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.notify.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.notify.service.NotifyService;
import com.jeeplus.notify.service.dto.NotifyDTO;
import com.jeeplus.sys.utils.UserUtils;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notify"})
public class NotifyController {
    @Autowired
    private NotifyService notifyService;

    @GetMapping(value={"list"})
    public ResponseEntity data(NotifyDTO notifyDTO, boolean isSelf, Page<NotifyDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)notifyDTO), NotifyDTO.class);
        IPage<NotifyDTO> result = this.notifyService.findPage(page, UserUtils.getCurrentUserDTO().getId(), isSelf, null, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(String id, boolean isSelf) {
        if (isSelf) {
            this.notifyService.updateReadFlag(id);
        }
        NotifyDTO notifyDTO = this.notifyService.getDetail(id);
        return ResponseEntity.ok((Object)((Object)notifyDTO));
    }

    @PreAuthorize(value="hasAnyAuthority('notify:add','notify:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody NotifyDTO notifyDTO) {
        if (StrUtil.isNotBlank((CharSequence)notifyDTO.getId())) {
            NotifyDTO e = this.notifyService.getById(notifyDTO.getId());
            if ("1".equals(e.getStatus())) {
                return ResponseEntity.badRequest().body((Object)"\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u64cd\u4f5c\uff01");
            }
            if (!UserUtils.getCurrentUserDTO().getId().equals(e.getCreateBy().getId())) {
                return ResponseEntity.badRequest().body((Object)"\u4f60\u53ea\u80fd\u7f16\u8f91\u81ea\u5df1\u7684\u516c\u544a!");
            }
        }
        this.notifyService.saveOrUpdate(notifyDTO);
        return ResponseEntity.ok((Object)("\u4fdd\u5b58\u901a\u77e5'" + notifyDTO.getTitle() + "'\u6210\u529f"));
    }

    @PreAuthorize(value="hasAuthority('notify:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.notifyService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u901a\u77e5\u6210\u529f");
    }
}

