/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.wps.controller;

import com.jeeplus.file.controller.FileController;
import com.jeeplus.office.domain.DocTemplate;
import com.jeeplus.office.service.DocTemplateService;
import com.jeeplus.sys.utils.UserUtils;
import com.jeeplus.wps.ApplicationProperties;
import com.jeeplus.wps.model.FileModel;
import com.jeeplus.wps.utils.WpsUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class WebOfficeController {
    @Value(value="${wps.downloadCallbackPath}")
    private String downloadCallbackPath;
    @Autowired
    private DocTemplateService docTemplateService;
    @Autowired
    FileController fileController;

    @RequestMapping(value={"/v1/3rd/file/info"}, method={RequestMethod.GET})
    public Object fileInfo(@RequestParam(value="_w_fname") String filename, String _w_userid, @RequestParam(value="_w_fileid") String fileid) throws Exception {
        JSONObject jsonObject = new JSONObject();
        JSONObject file = new JSONObject();
        JSONObject user = new JSONObject();
        try {
            FileModel fileModel = new FileModel();
            URL url = new URL(filename);
            URLConnection urlconn = url.openConnection();
            urlconn.connect();
            int filesize = urlconn.getContentLength();
            String name = filename.substring(filename.lastIndexOf("/") + 1);
            file.put("id", (Object)fileid);
            file.put("name", (Object)name);
            file.put("id", (Object)fileid);
            file.put("name", (Object)name);
            file.put("version", 1);
            file.put("size", filesize);
            file.put("creator", (Object)_w_userid);
            file.put("modifier", (Object)_w_userid);
            file.put("download_url", (Object)(FileModel.download_url + URLEncoder.encode(filename, "utf-8")));
            jsonObject.put("file", (Object)file);
            user.put("id", (Object)_w_userid);
            user.put("name", (Object)"admin");
            user.put("permission", (Object)"write");
            user.put("avatar_url", (Object)"");
            jsonObject.put("user", (Object)user);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    @RequestMapping(value={"/v1/3rd/file/save"}, method={RequestMethod.POST})
    public Object save(@RequestParam(value="file") MultipartFile file, HttpServletRequest request, String _w_userid, @RequestParam(value="_w_fname") String filename) throws Exception {
        String file1 = "/userdir/" + filename;
        File f = new File(file1);
        if (!file.isEmpty()) {
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                out.write(file.getBytes());
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        JSONObject jsonObject = new JSONObject();
        FileModel fileModel = new FileModel();
        JSONObject file2 = new JSONObject();
        String name = filename.substring(filename.lastIndexOf("/") + 1);
        String path = filename.substring(0, filename.lastIndexOf("/") + 1);
        String fileid = request.getHeader("x-weboffice-file-id");
        file2.put("id", (Object)fileid);
        file2.put("name", (Object)name);
        file2.put("version", 1);
        file2.put("size", file.getSize());
        file2.put("creator", (Object)_w_userid);
        file2.put("modifier", (Object)_w_userid);
        file2.put("download_url", (Object)(FileModel.download_url + path + URLEncoder.encode(name, "utf-8")));
        jsonObject.put("file", (Object)file2);
        return jsonObject.toString();
    }

    @GetMapping(value={"/weboffice/getFile"}, produces={"application/octet-stream;charset=UTF-8"})
    public ResponseEntity<byte[]> getFile(@RequestParam(value="_w_fname") String filename) throws Exception {
        String file1 = "/userdir/" + filename;
        System.out.println("Method getFile(" + filename + ") is invoked");
        File file = new File(file1);
        FileInputStream inputStream = new FileInputStream(file);
        byte[] body = new byte[((InputStream)inputStream).available()];
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), "UTF-8"));
        ((InputStream)inputStream).read(body);
        return new ResponseEntity((Object)body, (MultiValueMap)headers, HttpStatus.OK);
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    @RequestMapping(value={"/v1/3rd/file/version/{version}"}, method={RequestMethod.GET})
    public Object fileVersionInfo(@PathVariable(value="version") Long version, String _w_userid, @RequestParam(value="_w_fname") String filename) {
        JSONObject jsonObject = new JSONObject();
        JSONObject file = new JSONObject();
        JSONObject user = new JSONObject();
        try {
            FileModel fileModel = new FileModel();
            file.put("id", (Object)fileModel.id);
            file.put("name", (Object)filename);
            file.put("version", fileModel.version);
            file.put("size", fileModel.size);
            file.put("creator", (Object)_w_userid);
            file.put("modifier", (Object)_w_userid);
            file.put("download_url", (Object)filename);
            jsonObject.put("file", (Object)file);
            user.put("id", (Object)_w_userid);
            user.put("name", (Object)UserUtils.get((String)_w_userid).getName());
            user.put("permission", (Object)"write");
            user.put("avatar_url", (Object)"");
            jsonObject.put("user", (Object)user);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    @RequestMapping(value={"/v1/3rd/user/info"}, method={RequestMethod.POST})
    public Object userInfo(String _w_userid) {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONObject user = new JSONObject();
        try {
            user.put("id", (Object)_w_userid);
            user.put("name", (Object)UserUtils.get((String)_w_userid).getName());
            user.put("permission", (Object)"write");
            user.put("avatar_url", (Object)"");
            jsonArray.put((Object)user);
            jsonObject.put("users", (Object)jsonArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    @PostMapping(value={"/v1/3rd/file/new"})
    public String fileNew(@RequestBody MultipartFile file, HttpServletRequest request, String _w_userid, @RequestParam(value="_w_fname") String filename) throws Exception {
        String url = "";
        String type = "/w";
        type = filename.endsWith("xls") || filename.endsWith("xlsx") ? "/s" : (filename.endsWith("ppt") || filename.endsWith("pptx") ? "/p" : (filename.endsWith("pdf") ? "/f" : "/w"));
        url = this.fileController.upload(request, file).getBody().toString();
        DocTemplate docTemplate = new DocTemplate();
        docTemplate.setName(filename.split("\\.")[0]);
        docTemplate.setPath(url);
        this.docTemplateService.save((Object)docTemplate);
        String fileid = String.valueOf(new Date().getTime());
        String redirectUrl = ApplicationProperties.domain + "/office" + type + "/" + fileid + "?";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("_w_userid", _w_userid);
        paramMap.put("_w_appid", ApplicationProperties.appid);
        paramMap.put("_w_fname", url);
        paramMap.put("_w_fileid", fileid);
        String signature = WpsUtils.getSignature(paramMap, ApplicationProperties.appSecret);
        redirectUrl = redirectUrl + WpsUtils.getUrlParam(paramMap) + "&_w_signature=" + signature;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("redirect_url", (Object)redirectUrl);
        jsonObject.put("user_id", (Object)_w_userid);
        return jsonObject.toString();
    }

    @RequestMapping(value={"/v1/3rd/file/online"}, method={RequestMethod.POST})
    public void online() {
    }

    @RequestMapping(value={"/v1/3rd/file/history"}, method={RequestMethod.POST})
    public Object history() {
        JSONObject jsonObject = new JSONObject();
        return jsonObject.toString();
    }
}

